/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.spark.DataType;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

class SidecarCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicLong value;

    SidecarCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id.withTag((Tag)DataType.COUNTER);
        this.value = new AtomicLong(0L);
    }

    public Id id() {
        return this.id;
    }

    public void increment() {
        this.value.incrementAndGet();
    }

    public void increment(long amount) {
        this.value.addAndGet(amount);
    }

    public long count() {
        return this.value.get();
    }

    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), (double)this.value.getAndSet(0L));
        return Collections.singletonList(m);
    }

    public boolean hasExpired() {
        return false;
    }
}

