/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.codahale.metrics.MetricRegistry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import com.netflix.spectator.spark.SidecarRegistry;
import com.netflix.spectator.spark.SparkNameFunction;
import com.netflix.spectator.spark.SparkValueFunction;
import com.netflix.spectator.spark.SpectatorReporter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.sink.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSink
implements Sink {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSink.class);
    private static final String DEFAULT_URL = "http://localhost:8078/metrics";
    private final SpectatorReporter reporter;
    private final SidecarRegistry sidecarRegistry;
    private final long pollPeriod;
    private final TimeUnit pollUnit;
    private final URL url;
    private GcLogger gcLogger;

    public SparkSink(Properties properties, MetricRegistry registry, SecurityManager manager) throws MalformedURLException {
        Config config = this.loadConfig();
        this.sidecarRegistry = Spectator.registry().underlying(SidecarRegistry.class);
        this.reporter = SpectatorReporter.forRegistry(registry).withNameFunction(SparkNameFunction.fromConfig(config, this.sidecarRegistry)).withValueFunction(SparkValueFunction.fromConfig(config)).withGaugeCounters(Pattern.compile(config.getString("spectator.spark.gauge-counters"))).build();
        this.pollPeriod = this.getPeriod(properties);
        this.pollUnit = this.getUnit(properties);
        this.url = URI.create(properties.getProperty("url", DEFAULT_URL)).toURL();
    }

    private Config loadConfig() {
        return ConfigFactory.load(this.pickClassLoader());
    }

    private ClassLoader pickClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return this.getClass().getClassLoader();
        }
        return cl;
    }

    private void startJvmCollection() {
        try {
            Jmx.registerStandardMXBeans(Spectator.registry());
            this.gcLogger = new GcLogger();
            this.gcLogger.start(null);
        }
        catch (Exception e) {
            LOGGER.error("failed to start collection of jvm stats", (Throwable)e);
            throw e;
        }
    }

    private long getPeriod(Properties properties) {
        String v = properties.getProperty("period");
        return v == null ? 10L : Long.parseLong(v);
    }

    private TimeUnit getUnit(Properties properties) {
        String v = properties.getProperty("unit");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase(Locale.US));
    }

    public void start() {
        LOGGER.info("starting poller");
        this.reporter.start(this.pollPeriod, this.pollUnit);
        this.startJvmCollection();
        if (this.sidecarRegistry != null) {
            this.sidecarRegistry.start(this.url, this.pollPeriod, this.pollUnit);
        }
    }

    public void stop() {
        LOGGER.info("stopping poller");
        this.reporter.stop();
        this.gcLogger.stop();
        if (this.sidecarRegistry != null) {
            this.sidecarRegistry.stop();
        }
    }

    public void report() {
        LOGGER.info("reporting values");
        this.reporter.report();
    }
}

