/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.shadowedjson.JsonArray;
import com.netflix.spectator.shadowedjson.JsonObject;
import com.netflix.spectator.spark.DataType;
import com.netflix.spectator.spark.SidecarCounter;
import com.netflix.spectator.spark.SidecarDistributionSummary;
import com.netflix.spectator.spark.SidecarTimer;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class SidecarRegistry
extends AbstractRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarRegistry.class);
    private static final Callable<Map<String, String>> SPARK = new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            SparkEnv env = SparkEnv$.MODULE$.get();
            if (env == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> tagMap = new HashMap<String, String>();
            SparkConf conf = env.conf();
            this.put(tagMap, conf, "spark.app.id", "appId");
            this.put(tagMap, conf, "spark.app.name", "appName");
            this.put(tagMap, conf, "spark.executor.id", "executorId");
            return tagMap;
        }

        private void put(Map<String, String> tags, SparkConf conf, String key, String tagName) {
            Option opt = conf.getOption(key);
            if (opt.isDefined() && !"".equals(opt.get())) {
                tags.put(tagName, (String)opt.get());
            }
        }
    };
    private ScheduledExecutorService executor;
    private final Counter numMessages = this.counter(this.createId("spectator.sidecar.numMessages"));
    private final Counter numMeasurements = this.counter(this.createId("spectator.sidecar.numMeasurements"));
    private final Callable<Map<String, String>> commonTags;

    public SidecarRegistry() {
        this(Clock.SYSTEM);
    }

    public SidecarRegistry(Clock clock) {
        this(clock, SPARK);
    }

    public SidecarRegistry(Clock clock, Callable<Map<String, String>> commonTags) {
        super(clock);
        this.commonTags = commonTags;
    }

    public void start(final URL url, long pollPeriod, TimeUnit pollUnit) {
        LOGGER.info("starting sidecar registry with url {} and poll period {} {}", new Object[]{url, pollPeriod, pollUnit});
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "spectator-sidecar");
                t.setDaemon(true);
                return t;
            }
        });
        final SidecarRegistry self = this;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Measurement> ms = new ArrayList<Measurement>();
                    for (Meter meter : self) {
                        for (Measurement m : meter.measure()) {
                            ms.add(m);
                        }
                    }
                    SidecarRegistry.this.postJson(url, ms);
                }
                catch (Exception e) {
                    LOGGER.error("failed to send data to sidecar", (Throwable)e);
                }
            }
        };
        this.executor.scheduleWithFixedDelay(task, pollPeriod, pollPeriod, pollUnit);
    }

    public void stop() {
        this.executor.shutdown();
        this.executor = null;
    }

    private String toJson(List<Measurement> ms, Map<String, String> tags) {
        JsonArray items = new JsonArray();
        for (Measurement m : ms) {
            if (Double.isNaN(m.value()) || Double.isInfinite(m.value())) continue;
            items.add(this.toJson(m, tags));
        }
        return items.toString();
    }

    private JsonObject toJson(Measurement m, Map<String, String> tags) {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        for (Tag t : m.id().tags()) {
            tagMap.put(t.key(), t.value());
        }
        tagMap.putAll(tags);
        JsonObject obj = new JsonObject();
        obj.add("timestamp", m.timestamp());
        obj.add("type", this.getType(m.id()));
        obj.add("name", m.id().name());
        obj.add("tags", this.toJson(tagMap));
        obj.add("value", m.value());
        return obj;
    }

    private JsonObject toJson(Map<String, String> tags) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            obj.add(entry.getKey(), entry.getValue());
        }
        return obj;
    }

    private String getType(Id id) {
        for (Tag t : id.tags()) {
            if (!t.key().equals("type")) continue;
            return t.value();
        }
        return DataType.GAUGE.value();
    }

    private Map<String, String> getCommonTags() {
        try {
            return this.commonTags.call();
        }
        catch (Exception e) {
            LOGGER.warn("failed to determine common tags", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postJson(URL url, List<Measurement> ms) throws Exception {
        Map<String, String> tags = this.getCommonTags();
        if (!ms.isEmpty() && tags != null) {
            LOGGER.info("sending {} messages to sidecar {} with tags {}", new Object[]{ms.size(), url.toString(), tags});
            this.numMessages.increment();
            this.numMeasurements.increment(ms.size());
            String json = this.toJson(ms, tags);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try {
                con.setRequestMethod("POST");
                con.setDoInput(true);
                con.setDoOutput(true);
                try (OutputStream out = con.getOutputStream();){
                    out.write(json.getBytes("UTF-8"));
                }
                con.connect();
                int status = con.getResponseCode();
                if (status != 200) {
                    LOGGER.error("post to sidecar failed with status: " + status + ", payload: " + json);
                }
            }
            finally {
                con.disconnect();
            }
        }
    }

    @Override
    protected Counter newCounter(Id id) {
        return new SidecarCounter(this.clock(), id);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Id id) {
        return new SidecarDistributionSummary(this.clock(), id);
    }

    @Override
    protected Timer newTimer(Id id) {
        return new SidecarTimer(this.clock(), id);
    }
}

