/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.impl.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class DefaultId
implements Id {
    private final String name;
    private final TagList tags;

    public DefaultId(String name) {
        this(name, TagList.EMPTY);
    }

    DefaultId(String name, TagList tags) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.tags = tags;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<Tag> tags() {
        return this.tags == TagList.EMPTY ? Collections.emptyList() : this.tags;
    }

    @Override
    public DefaultId withTag(Tag tag) {
        return new DefaultId(this.name, new TagList(tag.key(), tag.value(), this.tags));
    }

    @Override
    public DefaultId withTag(String key, String value) {
        return new DefaultId(this.name, new TagList(key, value, this.tags));
    }

    @Override
    public DefaultId withTags(Iterable<Tag> ts) {
        TagList tmp = this.tags == TagList.EMPTY ? TagList.create(ts) : this.tags.prepend(ts);
        return new DefaultId(this.name, tmp);
    }

    @Override
    public DefaultId withTags(Map<String, String> ts) {
        return this.withTags((Iterable)TagList.create(ts));
    }

    DefaultId normalize() {
        return this.rollup(Collections.emptySet(), false);
    }

    DefaultId rollup(Set<String> keys, boolean keep) {
        TreeMap<String, String> ts = new TreeMap<String, String>();
        for (Tag t : this.tags) {
            if (keys.contains(t.key()) != keep || ts.containsKey(t.key())) continue;
            ts.put(t.key(), t.value());
        }
        return new DefaultId(this.name, TagList.create(ts));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultId)) {
            return false;
        }
        DefaultId other = (DefaultId)obj;
        return this.name.equals(other.name) && (this.tags == null && other.tags == null || this.tags != null && this.tags.equals(other.tags));
    }

    public int hashCode() {
        return this.name.hashCode() + (this.tags == null ? 0 : this.tags.hashCode());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        for (Tag t : this.tags()) {
            buf.append(":").append(t.key()).append("=").append(t.value());
        }
        return buf.toString();
    }
}

