/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;

final class CompositeCounter
extends CompositeMeter
implements Counter {
    private final Counter[] counters;

    CompositeCounter(Id id, Counter[] counters) {
        super(id);
        this.counters = counters;
    }

    @Override
    protected Meter[] meters() {
        return this.counters;
    }

    @Override
    public void increment() {
        for (Counter c : this.counters) {
            c.increment();
        }
    }

    @Override
    public void increment(long amount) {
        for (Counter c : this.counters) {
            c.increment(amount);
        }
    }

    @Override
    public long count() {
        return this.counters.length == 0 ? 0L : this.counters[0].count();
    }
}

