/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ConfigMap;
import java.util.NoSuchElementException;

public abstract class AbstractConfigMap
implements ConfigMap {
    @Override
    public String get(String key, String dflt) {
        String v = this.get(key);
        return v == null ? dflt : v;
    }

    private String getOrThrow(String key) {
        String v = this.get(key);
        if (v == null) {
            throw new NoSuchElementException(key);
        }
        return v;
    }

    @Override
    public int getInt(String key) {
        return Integer.parseInt(this.getOrThrow(key));
    }

    @Override
    public int getInt(String key, int dflt) {
        String v = this.get(key);
        return v == null ? dflt : Integer.parseInt(v);
    }

    @Override
    public long getLong(String key) {
        return Long.parseLong(this.getOrThrow(key));
    }

    @Override
    public long getLong(String key, long dflt) {
        String v = this.get(key);
        return v == null ? dflt : Long.parseLong(v);
    }

    @Override
    public double getDouble(String key) {
        return Double.parseDouble(this.getOrThrow(key));
    }

    @Override
    public double getDouble(String key, double dflt) {
        String v = this.get(key);
        return v == null ? dflt : Double.parseDouble(v);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getOrThrow(key));
    }

    @Override
    public boolean getBoolean(String key, boolean dflt) {
        String v = this.get(key);
        return v == null ? dflt : Boolean.parseBoolean(v);
    }
}

