/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.spark.DataType;
import com.netflix.spectator.spark.SidecarCounter;
import com.netflix.spectator.spark.SidecarDistributionSummary;
import com.netflix.spectator.spark.SidecarTimer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarRegistry
extends AbstractRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarRegistry.class);
    private ScheduledExecutorService executor;
    private final Counter numMessages = this.counter(this.createId("spectator.sidecar.numMessages"));
    private final Counter numMeasurements = this.counter(this.createId("spectator.sidecar.numMeasurements"));

    public SidecarRegistry() {
        this(Clock.SYSTEM);
    }

    public SidecarRegistry(Clock clock) {
        super(clock);
    }

    public void start(final URL url, long pollPeriod, TimeUnit pollUnit) {
        LOGGER.info("starting sidecar registry with url {} and poll period {} {}", new Object[]{url, pollPeriod, pollUnit});
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "spectator-sidecar");
            }
        });
        final SidecarRegistry self = this;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Measurement> ms = new ArrayList<Measurement>();
                    Iterator i$ = self.iterator();
                    while (i$.hasNext()) {
                        Meter meter = (Meter)i$.next();
                        for (Measurement m : meter.measure()) {
                            ms.add(m);
                        }
                    }
                    SidecarRegistry.this.postJson(url, ms);
                }
                catch (Exception e) {
                    LOGGER.error("failed to send data to sidecar", (Throwable)e);
                }
            }
        };
        this.executor.scheduleWithFixedDelay(task, pollPeriod, pollPeriod, pollUnit);
    }

    public void stop() {
        this.executor.shutdown();
        this.executor = null;
    }

    private String toJson(List<Measurement> ms) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        this.appendJson(buf, ms.get(0));
        for (int i = 1; i < ms.size(); ++i) {
            buf.append(',');
            this.appendJson(buf, ms.get(i));
        }
        buf.append(']');
        return buf.toString();
    }

    private void appendJson(StringBuilder buf, Measurement m) {
        if (!Double.isNaN(m.value()) && !Double.isInfinite(m.value())) {
            buf.append('{');
            this.appendJsonString(buf, "timestamp");
            buf.append(':').append(m.timestamp());
            buf.append(',');
            this.appendJsonString(buf, "type");
            buf.append(':');
            this.appendJsonString(buf, this.getType(m.id()));
            buf.append(',');
            this.appendJsonString(buf, "name");
            buf.append(':');
            this.appendJsonString(buf, m.id().name());
            buf.append(',');
            this.appendJsonString(buf, "tags");
            buf.append(":{");
            boolean first = true;
            for (Tag t : m.id().tags()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                this.appendJsonString(buf, t.key());
                buf.append(':');
                this.appendJsonString(buf, t.value());
            }
            buf.append("},");
            this.appendJsonString(buf, "value");
            buf.append(':');
            buf.append(m.value());
            buf.append('}');
        }
    }

    private String getType(Id id) {
        for (Tag t : id.tags()) {
            if (!t.key().equals("type")) continue;
            return t.value();
        }
        return DataType.GAUGE.value();
    }

    private void appendJsonString(StringBuilder buf, String s) {
        buf.append('\"');
        int length = s.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (s.charAt(i)) {
                case '\"': {
                    buf.append("\\\"");
                    continue block8;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postJson(URL url, List<Measurement> ms) throws Exception {
        if (!ms.isEmpty()) {
            LOGGER.debug("sending {} messages to sidecar {}", (Object)ms.size(), (Object)url.toString());
            this.numMessages.increment();
            this.numMeasurements.increment((long)ms.size());
            String json = this.toJson(ms);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try {
                con.setRequestMethod("POST");
                con.setDoInput(true);
                con.setDoOutput(true);
                try (OutputStream out = con.getOutputStream();){
                    out.write(json.getBytes("UTF-8"));
                }
                con.connect();
                int status = con.getResponseCode();
                if (status != 200) {
                    throw new IOException("post to sidecar failed with status: " + status);
                }
            }
            finally {
                con.disconnect();
            }
        }
    }

    protected Counter newCounter(Id id) {
        return new SidecarCounter(this.clock(), id);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new SidecarDistributionSummary(this.clock(), id);
    }

    protected Timer newTimer(Id id) {
        return new SidecarTimer(this.clock(), id);
    }
}

