/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.spark.SidecarCounter;
import java.util.ArrayList;

class SidecarDistributionSummary
implements DistributionSummary {
    private final Id id;
    private final Counter count;
    private final Counter totalAmount;

    SidecarDistributionSummary(Clock clock, Id id) {
        this.id = id;
        this.count = new SidecarCounter(clock, id.withTag((Tag)Statistic.count));
        this.totalAmount = new SidecarCounter(clock, id.withTag((Tag)Statistic.totalAmount));
    }

    public Id id() {
        return this.id;
    }

    public void record(long amount) {
        this.count.increment();
        this.totalAmount.increment(amount);
    }

    public long count() {
        return this.count.count();
    }

    public long totalAmount() {
        return this.totalAmount.count();
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Measurement m : this.count.measure()) {
            ms.add(m);
        }
        for (Measurement m : this.totalAmount.measure()) {
            ms.add(m);
        }
        return ms;
    }

    public boolean hasExpired() {
        return false;
    }
}

