/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.spark.NameFunction;
import com.netflix.spectator.spark.ValueFunction;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpectatorReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorReporter.class);
    private final ExtendedRegistry spectatorRegistry;
    private final NameFunction nameFunction;
    private final ValueFunction valueFunction;
    private final ConcurrentHashMap<String, AtomicDouble> gaugeDoubles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicLong> previousValues = new ConcurrentHashMap();

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    SpectatorReporter(MetricRegistry metricRegistry, ExtendedRegistry spectatorRegistry, NameFunction nameFunction, ValueFunction valueFunction) {
        super(metricRegistry, "spectator", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.spectatorRegistry = spectatorRegistry;
        this.nameFunction = nameFunction;
        this.valueFunction = valueFunction;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, com.codahale.metrics.Timer> timers) {
        long[] vs;
        LOGGER.debug("gauges {}, counters {}, histograms {}, meters {}, timers {}", new Object[]{gauges.size(), counters.size(), histograms.size(), meters.size(), timers.size()});
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Object obj = entry.getValue().getValue();
            if (!(obj instanceof Number)) continue;
            double v = ((Number)obj).doubleValue();
            this.setGaugeValue(entry.getKey(), v);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.setGaugeValue(entry.getKey(), ((Counter)entry.getValue()).getCount());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            Id id = this.nameFunction.apply(entry.getKey());
            if (id == null) continue;
            DistributionSummary sHisto = this.spectatorRegistry.distributionSummary(id);
            Histogram mHisto = (Histogram)entry.getValue();
            for (long v : vs = mHisto.getSnapshot().getValues()) {
                sHisto.record(v);
            }
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            long curr = ((Meter)entry.getValue()).getCount();
            long prev = this.getAndSetPrevious(entry.getKey(), curr);
            Id id = this.nameFunction.apply(entry.getKey());
            if (id == null) continue;
            this.spectatorRegistry.counter(id).increment(prev - curr);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            Id id = this.nameFunction.apply(entry.getKey());
            if (id == null) continue;
            Timer sTimer = this.spectatorRegistry.timer(id);
            com.codahale.metrics.Timer mTimer = (com.codahale.metrics.Timer)entry.getValue();
            for (long v : vs = mTimer.getSnapshot().getValues()) {
                sTimer.record(v, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void setGaugeValue(String name, double v) {
        AtomicDouble tmp;
        AtomicDouble value = this.gaugeDoubles.get(name);
        if (value == null && (value = this.gaugeDoubles.putIfAbsent(name, tmp = new AtomicDouble(v))) == null) {
            value = tmp;
            this.register(name, value);
        }
        double cv = this.valueFunction.convert(name, v);
        LOGGER.debug("setting gauge {} to {}", (Object)name, (Object)cv);
        value.set(cv);
    }

    private Id register(String name, AtomicDouble value) {
        Id id = this.nameFunction.apply(name);
        if (id != null) {
            this.spectatorRegistry.gauge(id, value);
        }
        return id;
    }

    private long getAndSetPrevious(String name, long newValue) {
        AtomicLong prev = this.previousValues.get(name);
        if (prev == null) {
            AtomicLong tmp = new AtomicLong(0L);
            prev = this.previousValues.putIfAbsent(name, tmp);
            prev = prev == null ? tmp : prev;
        }
        return prev.getAndSet(newValue);
    }

    public static final class Builder {
        private final MetricRegistry registry;
        private ExtendedRegistry spectatorRegistry = Spectator.registry();
        private NameFunction nameFunction = new NameFunction(){

            @Override
            public Id apply(String name) {
                return Builder.this.spectatorRegistry.createId(name);
            }
        };
        private ValueFunction valueFunction = new ValueFunction(){

            @Override
            public double convert(String name, double v) {
                return v;
            }
        };

        Builder(MetricRegistry registry) {
            this.registry = registry;
        }

        public Builder withSpectatorRegistry(ExtendedRegistry r) {
            this.spectatorRegistry = r;
            return this;
        }

        public Builder withNameFunction(NameFunction f) {
            this.nameFunction = f;
            return this;
        }

        public Builder withValueFunction(ValueFunction f) {
            this.valueFunction = f;
            return this;
        }

        public SpectatorReporter build() {
            return new SpectatorReporter(this.registry, this.spectatorRegistry, this.nameFunction, this.valueFunction);
        }
    }
}

