/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.codahale.metrics.MetricRegistry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.spark.SidecarRegistry;
import com.netflix.spectator.spark.SparkNameFunction;
import com.netflix.spectator.spark.SparkValueFunction;
import com.netflix.spectator.spark.SpectatorReporter;
import com.typesafe.config.ConfigFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.sink.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSink
implements Sink {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkSink.class);
    private static final String DEFAULT_URL = "http://localhost:8078/metrics";
    private final SpectatorReporter reporter;
    private final SidecarRegistry sidecarRegistry;
    private final long pollPeriod;
    private final TimeUnit pollUnit;
    private final URL url;

    public SparkSink(Properties properties, MetricRegistry registry, SecurityManager manager) throws MalformedURLException {
        this.reporter = SpectatorReporter.forRegistry(registry).withNameFunction(SparkNameFunction.fromConfig(ConfigFactory.load())).withValueFunction(SparkValueFunction.fromConfig(ConfigFactory.load())).build();
        this.pollPeriod = this.getPeriod(properties);
        this.pollUnit = this.getUnit(properties);
        this.url = URI.create(properties.getProperty("url", DEFAULT_URL)).toURL();
        this.sidecarRegistry = Spectator.registry().underlying(SidecarRegistry.class);
    }

    private long getPeriod(Properties properties) {
        String v = properties.getProperty("period");
        return v == null ? 10L : Long.parseLong(v);
    }

    private TimeUnit getUnit(Properties properties) {
        String v = properties.getProperty("unit");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase(Locale.US));
    }

    public void start() {
        LOGGER.info("starting poller");
        this.reporter.start(this.pollPeriod, this.pollUnit);
        if (this.sidecarRegistry != null) {
            this.sidecarRegistry.start(this.url, this.pollPeriod, this.pollUnit);
        }
    }

    public void stop() {
        LOGGER.info("stopping poller");
        this.reporter.stop();
        if (this.sidecarRegistry != null) {
            this.sidecarRegistry.stop();
        }
    }

    public void report() {
        LOGGER.info("reporting values");
        this.reporter.report();
    }
}

