/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.spark.NameFunction;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SparkNameFunction
implements NameFunction {
    private static final String PREFIX = "spark.";
    private static final Id DROP_METRIC = null;
    private final List<NameMatcher> matchers;

    public static SparkNameFunction fromConfig(Config config) {
        return SparkNameFunction.fromConfig(config, "spectator.spark.name-patterns");
    }

    public static SparkNameFunction fromConfig(Config config, String key) {
        return SparkNameFunction.fromPatternList(config.getConfigList(key));
    }

    private static SparkNameFunction fromPatternList(List<? extends Config> patterns) {
        ArrayList<NameMatcher> matchers = new ArrayList<NameMatcher>();
        for (Config config : patterns) {
            Pattern pattern = Pattern.compile(config.getString("pattern"));
            LinkedHashMap<String, Integer> tagsMap = new LinkedHashMap<String, Integer>();
            Config tagsCfg = config.getConfig("tags");
            for (Map.Entry<String, ConfigValue> entry : tagsCfg.entrySet()) {
                tagsMap.put(entry.getKey(), (Integer)entry.getValue().unwrapped());
            }
            matchers.add(new NameMatcher(pattern, config.getInt("name"), tagsMap));
        }
        return new SparkNameFunction(matchers);
    }

    private SparkNameFunction(List<NameMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public Id apply(String name) {
        for (NameMatcher matcher : this.matchers) {
            Id id = matcher.apply(name);
            if (id == DROP_METRIC) continue;
            return id;
        }
        return DROP_METRIC;
    }

    private static class NameMatcher {
        private final Pattern pattern;
        private final int name;
        private final Map<String, Integer> tags;

        NameMatcher(Pattern pattern, int name, Map<String, Integer> tags) {
            this.pattern = pattern;
            this.name = name;
            this.tags = tags;
        }

        Id apply(String metric) {
            Matcher m = this.pattern.matcher(metric);
            if (m.matches()) {
                Id id = new DefaultId(SparkNameFunction.PREFIX + m.group(this.name));
                for (Map.Entry<String, Integer> entry : this.tags.entrySet()) {
                    id = id.withTag(entry.getKey(), m.group(entry.getValue()));
                }
                return id;
            }
            return DROP_METRIC;
        }
    }
}

