/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.spark;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.spark.DataType;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

class SidecarCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicLong value;

    SidecarCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id.withTag(DataType.COUNTER);
        this.value = new AtomicLong(0L);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public void increment() {
        this.value.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.value.addAndGet(amount);
    }

    @Override
    public long count() {
        return this.value.get();
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value.getAndSet(0L));
        return Collections.singletonList(m);
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

