/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DoubleFunction;
import com.netflix.spectator.api.ValueFunction;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);
    public static final DoubleFunction IDENTITY = new DoubleFunction(){

        @Override
        public double apply(double v) {
            return v;
        }
    };
    public static final ValueFunction COLLECTION_SIZE = new ValueFunction(){

        @Override
        public double apply(Object obj) {
            return obj instanceof Collection ? (double)((Collection)obj).size() : Double.NaN;
        }
    };
    public static final ValueFunction MAP_SIZE = new ValueFunction(){

        @Override
        public double apply(Object obj) {
            return obj instanceof Map ? (double)((Map)obj).size() : Double.NaN;
        }
    };
    public static final DoubleFunction AGE = Functions.age(Clock.SYSTEM);

    private Functions() {
    }

    public static DoubleFunction age(final Clock clock) {
        return new DoubleFunction(){

            @Override
            public double apply(double t) {
                return ((double)clock.wallTime() - t) / 1000.0;
            }
        };
    }

    public static ValueFunction invokeMethod(final Method method) {
        method.setAccessible(true);
        return new ValueFunction(){

            @Override
            public double apply(Object obj) {
                try {
                    Number n = (Number)method.invoke(obj, new Object[0]);
                    return n.doubleValue();
                }
                catch (Exception e) {
                    LOGGER.warn("exception from method registered as a gauge [" + method + "]", (Throwable)e);
                    return Double.NaN;
                }
            }
        };
    }
}

