/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.sandbox;

import com.netflix.spectator.sandbox.HttpUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class HttpResponse {
    private final int status;
    private final Map<String, List<String>> headers;
    private final byte[] data;

    public HttpResponse(int status, Map<String, List<String>> headers) {
        this(status, headers, HttpUtils.EMPTY);
    }

    public HttpResponse(int status, Map<String, List<String>> headers, byte[] data) {
        this.status = status;
        TreeMap<String, List<String>> hs = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        hs.putAll(headers);
        this.headers = Collections.unmodifiableMap(hs);
        this.data = data;
    }

    public int status() {
        return this.status;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String header(String k) {
        List<String> vs = this.headers.get(k);
        return vs == null || vs.isEmpty() ? null : vs.get(0);
    }

    public Instant dateHeader(String k) {
        String d = this.header(k);
        return d == null ? null : this.parseDate(d);
    }

    private Instant parseDate(String d) {
        try {
            return LocalDateTime.parse(d, DateTimeFormatter.RFC_1123_DATE_TIME).atZone(ZoneOffset.UTC).toInstant();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] entity() {
        return this.data;
    }

    public String entityAsString() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public HttpResponse decompress() throws IOException {
        String enc = this.header("Content-Encoding");
        return enc != null && enc.contains("gzip") ? this.unzip() : this;
    }

    private HttpResponse unzip() throws IOException {
        Map<String, List<String>> newHeaders = this.headers.entrySet().stream().filter(e -> !"Content-Encoding".equalsIgnoreCase((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.data.length == 0) {
            return new HttpResponse(this.status, newHeaders);
        }
        return new HttpResponse(this.status, newHeaders, HttpUtils.gunzip(this.data));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(50);
        builder.append("HTTP/1.1 ").append(this.status).append('\n');
        for (Map.Entry<String, List<String>> h : this.headers.entrySet()) {
            for (String v : h.getValue()) {
                builder.append(h.getKey()).append(": ").append(v).append('\n');
            }
        }
        builder.append("\n... ").append(this.data.length).append(" bytes ...\n");
        return builder.toString();
    }
}

