/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.placeholders;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import com.netflix.spectator.placeholders.ConstantTagFactory;
import com.netflix.spectator.placeholders.PlaceholderId;
import com.netflix.spectator.placeholders.TagFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class DefaultPlaceholderId
implements PlaceholderId {
    private final String name;
    private final Collection<TagFactory> tagFactories;
    private final Registry registry;

    static DefaultPlaceholderId createWithFactories(String name, Iterable<TagFactory> tagFactories, Registry registry) {
        if (tagFactories == null) {
            return new DefaultPlaceholderId(name, registry);
        }
        FactorySorterAndDeduplicator sorter = new FactorySorterAndDeduplicator(tagFactories);
        return new DefaultPlaceholderId(name, sorter.asCollection(), registry);
    }

    DefaultPlaceholderId(String name, Registry registry) {
        this(name, Collections.emptyList(), registry);
    }

    private DefaultPlaceholderId(String name, Collection<TagFactory> tagFactories, Registry registry) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
        this.tagFactories = tagFactories;
        this.registry = registry;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DefaultPlaceholderId withTag(String k, String v) {
        return this.withTagFactory(new ConstantTagFactory((Tag)new BasicTag(k, v)));
    }

    @Override
    public DefaultPlaceholderId withTag(Tag t) {
        return this.withTagFactory(new ConstantTagFactory(t));
    }

    @Override
    public DefaultPlaceholderId withTags(Iterable<Tag> tags) {
        return this.createNewId(sorter -> tags.forEach(tag -> sorter.addFactory(new ConstantTagFactory((Tag)tag))));
    }

    @Override
    public DefaultPlaceholderId withTags(Map<String, String> tags) {
        return this.createNewId(sorter -> tags.forEach((key, value) -> sorter.addFactory(new ConstantTagFactory((Tag)new BasicTag(key, value)))));
    }

    @Override
    public DefaultPlaceholderId withTagFactory(TagFactory factory) {
        if (this.tagFactories.isEmpty()) {
            return new DefaultPlaceholderId(this.name, Collections.singleton(factory), this.registry);
        }
        return this.createNewId(sorter -> sorter.addFactory(factory));
    }

    @Override
    public DefaultPlaceholderId withTagFactories(Iterable<TagFactory> factories) {
        return this.createNewId(sorter -> sorter.addFactories(factories));
    }

    @Override
    public Id resolveToId() {
        Iterable tags = this.tagFactories.stream().map(TagFactory::createTag).filter(tag -> tag != null).collect(Collectors.toList());
        return this.registry.createId(this.name, tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPlaceholderId that = (DefaultPlaceholderId)o;
        return this.name.equals(that.name) && this.registry == that.registry && this.tagFactories.size() == that.tagFactories.size() && this.tagFactories.containsAll(that.tagFactories);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + 31 * this.registry.hashCode() + this.tagFactories.hashCode();
    }

    public String toString() {
        return this.resolveToId().toString();
    }

    private DefaultPlaceholderId createNewId(Consumer<FactorySorterAndDeduplicator> consumer) {
        FactorySorterAndDeduplicator sorter = new FactorySorterAndDeduplicator(this.tagFactories);
        consumer.accept(sorter);
        return new DefaultPlaceholderId(this.name, sorter.asCollection(), this.registry);
    }

    private static final class FactorySorterAndDeduplicator {
        private final Map<String, TagFactory> map = new TreeMap<String, TagFactory>();

        FactorySorterAndDeduplicator(Iterable<TagFactory> tagFactories) {
            this.addFactories(tagFactories);
        }

        void addFactory(TagFactory factory) {
            this.map.put(factory.name(), factory);
        }

        void addFactories(Iterable<TagFactory> factories) {
            for (TagFactory factory : factories) {
                this.map.put(factory.name(), factory);
            }
        }

        Collection<TagFactory> asCollection() {
            return Collections.unmodifiableCollection(this.map.values());
        }
    }
}

