/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.placeholders;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.placeholders.PlaceholderId;
import java.util.function.Function;

abstract class AbstractDefaultPlaceholderMeter<T extends Meter>
implements Meter {
    private final PlaceholderId id;
    private final Function<Id, T> meterResolver;

    AbstractDefaultPlaceholderMeter(PlaceholderId id, Function<Id, T> meterResolver) {
        this.id = id;
        this.meterResolver = meterResolver;
    }

    protected final T resolveToCurrentMeter() {
        return (T)((Meter)this.meterResolver.apply(this.id()));
    }

    public final Id id() {
        return this.id.resolveToId();
    }

    public final Iterable<Measurement> measure() {
        return this.resolveToCurrentMeter().measure();
    }

    public final boolean hasExpired() {
        return false;
    }
}

