/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.log4j;

import com.netflix.spectator.api.Tag;
import org.apache.log4j.Level;

enum LevelTag implements Tag
{
    OFF(Level.OFF),
    FATAL(Level.FATAL),
    ERROR(Level.ERROR),
    WARN(Level.WARN),
    INFO(Level.INFO),
    DEBUG(Level.DEBUG),
    TRACE(Level.TRACE),
    ALL(Level.ALL);

    private final Level std;
    private final String value;

    private LevelTag(Level std) {
        this.std = std;
        this.value = String.format("%d_%s", this.ordinal(), std.toString());
    }

    public String key() {
        return "loglevel";
    }

    public String value() {
        return this.value;
    }

    Level standardLevel() {
        return this.std;
    }

    static LevelTag get(Level level) {
        LevelTag tag = OFF;
        switch (level.toInt()) {
            case 0x7FFFFFFF: {
                tag = OFF;
                break;
            }
            case 50000: {
                tag = FATAL;
                break;
            }
            case 40000: {
                tag = ERROR;
                break;
            }
            case 30000: {
                tag = WARN;
                break;
            }
            case 20000: {
                tag = INFO;
                break;
            }
            case 10000: {
                tag = DEBUG;
                break;
            }
            case 5000: {
                tag = TRACE;
                break;
            }
            case -2147483648: {
                tag = ALL;
                break;
            }
        }
        return tag;
    }
}

