/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.log4j;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.log4j.LevelTag;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class SpectatorAppender
extends AppenderSkeleton {
    private final Registry registry;
    private final Id[] numMessages;
    private final Id[] numStackTraces;

    public SpectatorAppender() {
        this((Registry)Spectator.globalRegistry());
    }

    public SpectatorAppender(Registry registry) {
        this.registry = registry;
        LevelTag[] levels = LevelTag.values();
        this.numMessages = new Id[levels.length];
        this.numStackTraces = new Id[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            this.numMessages[i] = registry.createId("log4j.numMessages").withTag((Tag)levels[i]);
            this.numStackTraces[i] = registry.createId("log4j.numStackTraces").withTag((Tag)levels[i]);
        }
    }

    protected void append(LoggingEvent event) {
        LevelTag level = LevelTag.get(event.getLevel());
        this.registry.counter(this.numMessages[level.ordinal()]).increment();
        ThrowableInformation info = event.getThrowableInformation();
        if (info != null) {
            LocationInfo loc = event.getLocationInformation();
            String file = loc == null ? "unknown" : loc.getFileName();
            Id stackTraceId = this.numStackTraces[level.ordinal()].withTag("exception", info.getThrowable().getClass().getSimpleName()).withTag("file", file);
            this.registry.counter(stackTraceId).increment();
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

