/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipcservlet;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.ipc.IpcLogEntry;
import com.netflix.spectator.ipc.IpcLogger;
import com.netflix.spectator.ipc.NetflixHeader;
import com.netflix.spectator.ipc.NetflixHeaders;
import com.netflix.spectator.ipcservlet.ServletPathHack;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IpcServletFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpcServletFilter.class);
    private final IpcLogger ipcLogger;
    private final Map<String, String> netflixHeaders;

    public IpcServletFilter() {
        this((Registry)Spectator.globalRegistry());
    }

    @Inject
    public IpcServletFilter(Registry registry) {
        this.ipcLogger = new IpcLogger(registry, LOGGER);
        this.netflixHeaders = NetflixHeaders.extractFromEnvironment();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            HttpServletResponse httpRes = (HttpServletResponse)response;
            String endpoint = this.getEndpoint(httpReq);
            IpcLogEntry entry = this.ipcLogger.createServerEntry().withOwner("spectator").withHttpMethod(httpReq.getMethod()).withUri(httpReq.getRequestURI(), httpReq.getRequestURI());
            this.addRequestHeaders(httpReq, entry);
            entry.markStart();
            try {
                chain.doFilter(request, response);
                entry.markEnd().withHttpStatus(httpRes.getStatus());
            }
            catch (Throwable t) {
                entry.markEnd().withException(t).withHttpStatus(500);
                throw t;
            }
            finally {
                this.addNetflixHeaders(httpRes, endpoint);
                this.addResponseHeaders(httpRes, entry);
                entry.log();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private String getEndpoint(HttpServletRequest httpReq) {
        String servletPath = ServletPathHack.getServletPath(httpReq);
        return servletPath == null || servletPath.isEmpty() ? "/" : servletPath;
    }

    private void addNetflixHeaders(HttpServletResponse httpRes, String endpoint) {
        this.addIfNotPresent(httpRes, NetflixHeader.Endpoint.headerName(), endpoint);
        for (Map.Entry<String, String> entry : this.netflixHeaders.entrySet()) {
            this.addIfNotPresent(httpRes, entry.getKey(), entry.getValue());
        }
    }

    private void addIfNotPresent(HttpServletResponse httpRes, String name, String value) {
        if (httpRes.getHeader(name) == null) {
            httpRes.addHeader(name, value);
        }
    }

    private void addRequestHeaders(HttpServletRequest httpReq, IpcLogEntry entry) {
        Enumeration headers = httpReq.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            Enumeration values = httpReq.getHeaders(header);
            while (values.hasMoreElements()) {
                entry.addRequestHeader(header, (String)values.nextElement());
            }
        }
    }

    private void addResponseHeaders(HttpServletResponse httpRes, IpcLogEntry entry) {
        Collection headers = httpRes.getHeaderNames();
        for (String header : headers) {
            Collection values = httpRes.getHeaders(header);
            for (String value : values) {
                entry.addResponseHeader(header, value);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

