/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.gc;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.gc.CircularBuffer;
import com.netflix.spectator.gc.GcEvent;
import com.netflix.spectator.gc.GcEventListener;
import com.netflix.spectator.gc.GcType;
import com.netflix.spectator.gc.HelperFunctions;
import com.netflix.spectator.impl.Preconditions;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GcLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcLogger.class);
    private static final int BUFFER_SIZE = 256;
    private static final AtomicLong MAX_DATA_SIZE = (AtomicLong)Spectator.registry().gauge("jvm.gc.maxDataSize", (Number)new AtomicLong(0L));
    private static final AtomicLong LIVE_DATA_SIZE = (AtomicLong)Spectator.registry().gauge("jvm.gc.liveDataSize", (Number)new AtomicLong(0L));
    private static final Counter PROMOTION_RATE = Spectator.registry().counter("jvm.gc.promotionRate");
    private static final Counter ALLOCATION_RATE = Spectator.registry().counter("jvm.gc.allocationRate");
    private static final Id PAUSE_TIME = Spectator.registry().createId("jvm.gc.pause");
    private final long jvmStartTime;
    private final ConcurrentHashMap<String, CircularBuffer<GcEvent>> gcLogs = new ConcurrentHashMap();
    private long youngGenSizeAfter = 0L;
    private String youngGenPoolName = null;
    private String oldGenPoolName = null;
    private GcNotificationListener notifListener = null;
    private GcEventListener eventListener = null;

    public GcLogger() {
        this.jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            CircularBuffer buffer = new CircularBuffer(256);
            this.gcLogs.put(garbageCollectorMXBean.getName(), buffer);
        }
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (HelperFunctions.isYoungGenPool(memoryPoolMXBean.getName())) {
                this.youngGenPoolName = memoryPoolMXBean.getName();
            }
            if (!HelperFunctions.isOldGenPool(memoryPoolMXBean.getName())) continue;
            this.oldGenPoolName = memoryPoolMXBean.getName();
        }
    }

    public synchronized void start(GcEventListener listener) {
        if (this.notifListener != null) {
            LOGGER.warn("logger already started");
            return;
        }
        this.eventListener = listener;
        this.notifListener = new GcNotificationListener();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(this.notifListener, null, null);
        }
    }

    public synchronized void stop() {
        Preconditions.checkState((this.notifListener != null ? 1 : 0) != 0, (String)"logger has not been started");
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            try {
                emitter.removeNotificationListener(this.notifListener);
            }
            catch (ListenerNotFoundException e) {
                LOGGER.warn("could not remove gc listener", (Throwable)e);
            }
        }
        this.notifListener = null;
    }

    public List<GcEvent> getLogs() {
        ArrayList<GcEvent> logs = new ArrayList<GcEvent>();
        for (CircularBuffer<GcEvent> buffer : this.gcLogs.values()) {
            logs.addAll(buffer.toList());
        }
        Collections.sort(logs, GcEvent.REVERSE_TIME_ORDER);
        return logs;
    }

    private void updateMetrics(String name, GcInfo info) {
        long delta;
        Map<String, MemoryUsage> before = info.getMemoryUsageBeforeGc();
        Map<String, MemoryUsage> after = info.getMemoryUsageAfterGc();
        if (this.oldGenPoolName != null) {
            long oldBefore = before.get(this.oldGenPoolName).getUsed();
            long oldAfter = after.get(this.oldGenPoolName).getUsed();
            delta = oldAfter - oldBefore;
            if (delta > 0L) {
                PROMOTION_RATE.increment(delta);
            }
            if (oldAfter < oldBefore || HelperFunctions.getGcType(name) == GcType.OLD) {
                LIVE_DATA_SIZE.set(oldAfter);
                long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                MAX_DATA_SIZE.set(oldMaxAfter);
            }
        }
        if (this.youngGenPoolName != null) {
            long youngBefore = before.get(this.youngGenPoolName).getUsed();
            long youngAfter = after.get(this.youngGenPoolName).getUsed();
            delta = youngBefore - this.youngGenSizeAfter;
            this.youngGenSizeAfter = youngAfter;
            if (delta > 0L) {
                ALLOCATION_RATE.increment(delta);
            }
        }
    }

    private void processGcEvent(GarbageCollectionNotificationInfo info) {
        GcEvent event = new GcEvent(info, this.jvmStartTime + info.getGcInfo().getStartTime());
        this.gcLogs.get(info.getGcName()).add(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(event.toString());
        }
        Id eventId = PAUSE_TIME.withTag("action", info.getGcAction()).withTag("cause", info.getGcCause());
        Timer timer = Spectator.registry().timer(eventId);
        timer.record(info.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
        this.updateMetrics(info.getGcName(), info.getGcInfo());
        if (this.eventListener != null) {
            try {
                this.eventListener.onComplete(event);
            }
            catch (Exception e) {
                LOGGER.warn("exception thrown by event listener", (Throwable)e);
            }
        }
    }

    private class GcNotificationListener
    implements NotificationListener {
        private GcNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object ref) {
            String type = notification.getType();
            if (type.equals("com.sun.management.gc.notification")) {
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd);
                GcLogger.this.processGcEvent(info);
            }
        }
    }
}

