/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.gc;

import com.netflix.spectator.gc.GcType;
import com.netflix.spectator.gc.HelperFunctions;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.util.Comparator;
import java.util.Date;

public class GcEvent {
    private final String name;
    private final GarbageCollectionNotificationInfo info;
    private final GcType type;
    private final long startTime;
    public static final Comparator<GcEvent> TIME_ORDER = new Comparator<GcEvent>(){

        @Override
        public int compare(GcEvent e1, GcEvent e2) {
            return (int)(e1.getStartTime() - e2.getStartTime());
        }
    };
    public static final Comparator<GcEvent> REVERSE_TIME_ORDER = new Comparator<GcEvent>(){

        @Override
        public int compare(GcEvent e1, GcEvent e2) {
            return (int)(e2.getStartTime() - e1.getStartTime());
        }
    };

    public GcEvent(GarbageCollectionNotificationInfo info, long startTime) {
        this.name = info.getGcName();
        this.info = info;
        this.type = HelperFunctions.getGcType(this.name);
        this.startTime = startTime;
    }

    public GcType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public GarbageCollectionNotificationInfo getInfo() {
        return this.info;
    }

    public String toString() {
        GcInfo gcInfo = this.info.getGcInfo();
        long totalBefore = HelperFunctions.getTotalUsage(gcInfo.getMemoryUsageBeforeGc());
        long totalAfter = HelperFunctions.getTotalUsage(gcInfo.getMemoryUsageAfterGc());
        long max = HelperFunctions.getTotalMaxUsage(gcInfo.getMemoryUsageAfterGc());
        String unit = "K";
        double cnv = 1000.0;
        if (max > 1000000000L) {
            unit = "G";
            cnv = 1.0E9;
        } else if (max > 1000000L) {
            unit = "M";
            cnv = 1000000.0;
        }
        String change = String.format("%.1f%s => %.1f%s / %.1f%s", (double)totalBefore / cnv, unit, (double)totalAfter / cnv, unit, (double)max / cnv, unit);
        String percentChange = String.format("%.1f%% => %.1f%%", 100.0 * (double)totalBefore / (double)max, 100.0 * (double)totalAfter / (double)max);
        Date d = new Date(this.startTime);
        return this.type.toString() + ": " + this.name + ", id=" + gcInfo.getId() + ", at=" + d.toString() + ", duration=" + gcInfo.getDuration() + "ms" + ", cause=[" + this.info.getGcCause() + "]" + ", " + change + " (" + percentChange + ")";
    }
}

