/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.Preconditions;
import java.beans.Introspector;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpectatorRequestMetricCollector
extends RequestMetricCollector {
    public static final HandlerContextKey<String> DEFAULT_HANDLER_CONTEXT_KEY = new HandlerContextKey("ClientIdKey");
    private static final Logger LOGGER = LoggerFactory.getLogger(SpectatorRequestMetricCollector.class);
    private static final Set<String> ALL_DEFAULT_TAGS = new HashSet<String>();
    private static final String TAG_ERROR = "error";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_THROTTLE_EXCEPTION = "throttleException";
    private static final String UNKNOWN = "UNKNOWN";
    private static final AWSRequestMetrics.Field[] TIMERS = new AWSRequestMetrics.Field[]{AWSRequestMetrics.Field.ClientExecuteTime, AWSRequestMetrics.Field.CredentialsRequestTime, AWSRequestMetrics.Field.HttpClientReceiveResponseTime, AWSRequestMetrics.Field.HttpClientSendRequestTime, AWSRequestMetrics.Field.HttpRequestTime, AWSRequestMetrics.Field.RequestMarshallTime, AWSRequestMetrics.Field.RequestSigningTime, AWSRequestMetrics.Field.ResponseProcessingTime, AWSRequestMetrics.Field.RetryPauseTime};
    private static final AWSRequestMetrics.Field[] COUNTERS = new AWSRequestMetrics.Field[]{AWSRequestMetrics.Field.BytesProcessed, AWSRequestMetrics.Field.HttpClientRetryCount, AWSRequestMetrics.Field.RequestCount};
    private static final AWSRequestMetrics.Field[] GAUGES = new AWSRequestMetrics.Field[]{AWSRequestMetrics.Field.HttpClientPoolAvailableCount, AWSRequestMetrics.Field.HttpClientPoolLeasedCount, AWSRequestMetrics.Field.HttpClientPoolPendingCount};
    private static final TagField[] TAGS = new TagField[]{new TagField(AWSRequestMetrics.Field.ServiceEndpoint, SpectatorRequestMetricCollector::getHost), new TagField(AWSRequestMetrics.Field.ServiceName), new TagField(AWSRequestMetrics.Field.StatusCode)};
    private static final TagField[] ERRORS = new TagField[]{new TagField(AWSRequestMetrics.Field.AWSErrorCode), new TagField(AWSRequestMetrics.Field.Exception, e -> e.getClass().getSimpleName())};
    private final Registry registry;
    private final Map<String, String> customTags;
    private final HandlerContextKey<String> handlerContextKey;

    public SpectatorRequestMetricCollector(Registry registry) {
        this(registry, Collections.emptyMap(), DEFAULT_HANDLER_CONTEXT_KEY);
    }

    public SpectatorRequestMetricCollector(Registry registry, HandlerContextKey<String> handlerContextKey) {
        this(registry, Collections.emptyMap(), handlerContextKey);
    }

    public SpectatorRequestMetricCollector(Registry registry, Map<String, String> customTags) {
        this(registry, customTags, DEFAULT_HANDLER_CONTEXT_KEY);
    }

    public SpectatorRequestMetricCollector(Registry registry, Map<String, String> customTags, HandlerContextKey<String> handlerContextKey) {
        this.registry = (Registry)Preconditions.checkNotNull((Object)registry, (String)"registry");
        Preconditions.checkNotNull(customTags, (String)"customTags");
        this.customTags = new HashMap<String, String>();
        customTags.forEach((key, value) -> {
            if (ALL_DEFAULT_TAGS.contains(key)) {
                registry.propagate((Throwable)new IllegalArgumentException("Invalid custom tag " + key + " - cannot override built-in tag"));
            } else if (value == null) {
                registry.propagate((Throwable)new NullPointerException("Custom tag value for key " + key + " is null"));
            } else {
                this.customTags.put((String)key, (String)value);
            }
        });
        Preconditions.checkNotNull(handlerContextKey, (String)"handlerContextKey");
        this.handlerContextKey = handlerContextKey;
        String keyName = this.handlerContextKey.getName();
        if (ALL_DEFAULT_TAGS.contains(keyName)) {
            registry.propagate((Throwable)new IllegalArgumentException("Invalid handler context key " + keyName + " - cannot override built-in tag"));
        }
    }

    public void collectMetrics(Request<?> request, Response<?> response) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        if (metrics.isEnabled()) {
            Map<String, String> allTags = this.getAllTags(request);
            TimingInfo timing = metrics.getTimingInfo();
            for (AWSRequestMetrics.Field counter : COUNTERS) {
                Optional.ofNullable(timing.getCounter(counter.name())).filter(v -> v.longValue() > 0L).ifPresent(v -> this.registry.counter(this.metricId(counter, allTags)).increment(v.longValue()));
            }
            for (AWSRequestMetrics.Field timer : TIMERS) {
                Optional.ofNullable(timing.getLastSubMeasurement(timer.name())).filter(TimingInfo::isEndTimeKnown).ifPresent(t -> this.registry.timer(this.metricId(timer, allTags)).record(t.getEndTimeNano() - t.getStartTimeNano(), TimeUnit.NANOSECONDS));
            }
            if (request.getHandlerContext(this.handlerContextKey) != null) {
                for (AWSRequestMetrics.Field gauge : GAUGES) {
                    Optional.ofNullable(timing.getCounter(gauge.name())).ifPresent(v -> this.registry.gauge(this.metricId(gauge, allTags)).set(v.doubleValue()));
                }
            }
            SpectatorRequestMetricCollector.notEmpty(metrics.getProperty((MetricType)AWSRequestMetrics.Field.ThrottleException)).ifPresent(throttleExceptions -> {
                Id throttling = this.metricId("throttling", allTags);
                throttleExceptions.forEach(ex -> this.registry.counter(throttling.withTag(TAG_THROTTLE_EXCEPTION, ex.getClass().getSimpleName())).increment());
            });
        }
    }

    private Id metricId(AWSRequestMetrics.Field metric, Map<String, String> tags) {
        return this.metricId(metric.name(), tags);
    }

    private Id metricId(String metric, Map<String, String> tags) {
        return this.registry.createId(SpectatorRequestMetricCollector.idName(metric), tags);
    }

    private Map<String, String> getAllTags(Request<?> request) {
        boolean error;
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        HashMap<String, String> allTags = new HashMap<String, String>();
        for (TagField tag : TAGS) {
            allTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
        }
        allTags.put(TAG_REQUEST_TYPE, request.getOriginalRequest().getClass().getSimpleName());
        String contextTagValue = (String)request.getHandlerContext(this.handlerContextKey);
        if (contextTagValue != null) {
            allTags.put(this.handlerContextKey.getName(), contextTagValue);
        }
        if (error = SpectatorRequestMetricCollector.isError(metrics)) {
            for (TagField tag : ERRORS) {
                allTags.put(tag.getName(), tag.getValue(metrics).orElse(UNKNOWN));
            }
        }
        allTags.put(TAG_ERROR, Boolean.toString(error));
        allTags.putAll(this.customTags);
        return Collections.unmodifiableMap(allTags);
    }

    static String idName(String name) {
        return "aws.request." + Introspector.decapitalize(name);
    }

    private static Optional<List<Object>> notEmpty(List<Object> properties) {
        return Optional.ofNullable(properties).filter(v -> !v.isEmpty());
    }

    static <R> Optional<R> firstValue(List<Object> properties, Function<Object, R> transform) {
        return SpectatorRequestMetricCollector.notEmpty(properties).map(v -> v.get(0)).map(transform::apply);
    }

    private static boolean isError(AWSRequestMetrics metrics) {
        for (TagField err : ERRORS) {
            if (!err.getValue(metrics).isPresent()) continue;
            return true;
        }
        return false;
    }

    private static String getHost(Object u) {
        try {
            return URI.create(u.toString()).getHost();
        }
        catch (Exception e) {
            LOGGER.debug("failed to parse endpoint uri: " + u, (Throwable)e);
            return UNKNOWN;
        }
    }

    static {
        Stream.concat(Arrays.stream(TAGS), Arrays.stream(ERRORS)).map(TagField::getName).forEach(ALL_DEFAULT_TAGS::add);
        ALL_DEFAULT_TAGS.addAll(Arrays.asList(TAG_THROTTLE_EXCEPTION, TAG_REQUEST_TYPE, TAG_ERROR));
    }

    private static class TagField {
        private final AWSRequestMetrics.Field field;
        private final String name;
        private final Function<Object, String> tagExtractor;

        TagField(AWSRequestMetrics.Field field) {
            this(field, Object::toString);
        }

        TagField(AWSRequestMetrics.Field field, Function<Object, String> tagExtractor) {
            this.field = field;
            this.tagExtractor = tagExtractor;
            this.name = Introspector.decapitalize(field.name());
        }

        String getName() {
            return this.name;
        }

        Optional<String> getValue(AWSRequestMetrics metrics) {
            return SpectatorRequestMetricCollector.firstValue(metrics.getProperty((MetricType)this.field), this.tagExtractor);
        }
    }
}

