/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.aws;

import com.amazonaws.metrics.ByteThroughputProvider;
import com.amazonaws.metrics.ServiceLatencyProvider;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.util.AWSServiceMetrics;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.concurrent.TimeUnit;

class SpectatorServiceMetricCollector
extends ServiceMetricCollector {
    private final Timer clientGetConnectionTime;

    SpectatorServiceMetricCollector(Registry registry) {
        this.clientGetConnectionTime = registry.timer("aws.request.httpClientGetConnectionTime");
    }

    public void collectByteThroughput(ByteThroughputProvider provider) {
    }

    public void collectLatency(ServiceLatencyProvider provider) {
        if (provider.getServiceMetricType() == AWSServiceMetrics.HttpClientGetConnectionTime) {
            long nanos = (long)(provider.getDurationMilli() * 1000000.0);
            this.clientGetConnectionTime.record(nanos, TimeUnit.NANOSECONDS);
        }
    }
}

