/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class StepDouble
implements StepValue {
    private final double init;
    private final Clock clock;
    private final long step;
    private volatile double previous;
    private volatile long current;
    private static final AtomicLongFieldUpdater<StepDouble> CURRENT_UPDATER = AtomicLongFieldUpdater.newUpdater(StepDouble.class, "current");
    private volatile long lastInitPos;
    private static final AtomicLongFieldUpdater<StepDouble> LAST_INIT_POS_UPDATER = AtomicLongFieldUpdater.newUpdater(StepDouble.class, "lastInitPos");

    public StepDouble(double init, Clock clock, long step) {
        this.init = init;
        this.clock = clock;
        this.step = step;
        this.previous = init;
        this.current = Double.doubleToLongBits(init);
        this.lastInitPos = clock.wallTime() / step;
    }

    private void rollCount(long now) {
        long lastInit = this.lastInitPos;
        long stepTime = now / this.step;
        if (lastInit < stepTime && LAST_INIT_POS_UPDATER.compareAndSet(this, lastInit, stepTime)) {
            double v = Double.longBitsToDouble(CURRENT_UPDATER.getAndSet(this, Double.doubleToLongBits(this.init)));
            this.previous = lastInit == stepTime - 1L ? v : this.init;
        }
    }

    public double getCurrent() {
        return this.getCurrent(this.clock.wallTime());
    }

    public double getCurrent(long now) {
        this.rollCount(now);
        return Double.longBitsToDouble(this.current);
    }

    public void setCurrent(long now, double value) {
        this.rollCount(now);
        this.current = Double.doubleToLongBits(value);
    }

    public double addAndGet(long now, double amount) {
        double d;
        double n;
        long next;
        long v;
        this.rollCount(now);
        while (!CURRENT_UPDATER.compareAndSet(this, v = this.current, next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return n;
    }

    public double getAndAdd(long now, double amount) {
        double d;
        double n;
        long next;
        long v;
        this.rollCount(now);
        while (!CURRENT_UPDATER.compareAndSet(this, v = this.current, next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return d;
    }

    public double getAndSet(long now, double value) {
        this.rollCount(now);
        long v = CURRENT_UPDATER.getAndSet(this, Double.doubleToLongBits(value));
        return Double.longBitsToDouble(v);
    }

    private boolean compareAndSet(double expect, double update) {
        long e = Double.doubleToLongBits(expect);
        long u = Double.doubleToLongBits(update);
        return CURRENT_UPDATER.compareAndSet(this, e, u);
    }

    public boolean compareAndSet(long now, double expect, double update) {
        this.rollCount(now);
        return this.compareAndSet(expect, update);
    }

    private static boolean isLessThan(double v1, double v2) {
        return v1 < v2 || Double.isNaN(v2);
    }

    public void min(long now, double value) {
        if (Double.isFinite(value)) {
            this.rollCount(now);
            double min = Double.longBitsToDouble(this.current);
            while (StepDouble.isLessThan(value, min) && !this.compareAndSet(min, value)) {
                min = Double.longBitsToDouble(this.current);
            }
        }
    }

    private static boolean isGreaterThan(double v1, double v2) {
        return v1 > v2 || Double.isNaN(v2);
    }

    public void max(long now, double value) {
        if (Double.isFinite(value)) {
            this.rollCount(now);
            double max = Double.longBitsToDouble(this.current);
            while (StepDouble.isGreaterThan(value, max) && !this.compareAndSet(max, value)) {
                max = Double.longBitsToDouble(this.current);
            }
        }
    }

    public double poll() {
        return this.poll(this.clock.wallTime());
    }

    public double poll(long now) {
        this.rollCount(now);
        return this.previous;
    }

    @Override
    public double pollAsRate() {
        return this.pollAsRate(this.clock.wallTime());
    }

    @Override
    public double pollAsRate(long now) {
        double amount = this.poll(now);
        double period = (double)this.step / 1000.0;
        return amount / period;
    }

    @Override
    public long timestamp() {
        return this.lastInitPos * this.step;
    }

    public String toString() {
        return "StepDouble{init=" + this.init + ", previous=" + this.previous + ", current=" + Double.longBitsToDouble(this.current) + ", lastInitPos=" + this.lastInitPos + '}';
    }
}

