/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import java.util.ArrayList;
import java.util.Collection;

class CompositeMeter<T extends Meter>
implements Meter {
    protected final Id id;
    protected final Collection<T> meters;

    public CompositeMeter(Id id, Collection<T> meters) {
        this.id = id;
        this.meters = meters;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        for (Meter m : this.meters) {
            if (m == null || m.hasExpired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Meter m : this.meters) {
            if (m == null) continue;
            for (Measurement measurement : m.measure()) {
                ms.add(measurement);
            }
        }
        return ms;
    }
}

