/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.SwapMeter;

final class SwapGauge
implements Gauge,
SwapMeter<Gauge> {
    private final Registry registry;
    private final Id id;
    private volatile Gauge underlying;

    SwapGauge(Registry registry, Id id, Gauge underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        Gauge g = this.underlying;
        return g == null || g.hasExpired();
    }

    @Override
    public void set(double value) {
        this.get().set(value);
    }

    @Override
    public double value() {
        return this.get().value();
    }

    @Override
    public void set(Gauge g) {
        this.underlying = g;
    }

    @Override
    public Gauge get() {
        Gauge g = this.underlying;
        if (g == null) {
            this.underlying = g = this.unwrap(this.registry.gauge(this.id));
        }
        return g;
    }

    private Gauge unwrap(Gauge g) {
        Gauge tmp = g;
        while (tmp instanceof SwapGauge) {
            tmp = ((SwapGauge)tmp).get();
        }
        return tmp;
    }
}

