/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.RegistryConfig;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private static final String PREFIX = "spectator.api.";
    private static final Map<Class<?>, Function<String, Object>> PARSERS = new HashMap();
    private static final RegistryConfig DEFAULT_CONFIG;

    private Config() {
    }

    private static ClassLoader classLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? Config.class.getClassLoader() : cl;
    }

    private static Object valueOf(Class<?> to, String value) {
        return PARSERS.get(to).apply(value);
    }

    private static Constructor<MethodHandles.Lookup> getConstructor() {
        try {
            Constructor<MethodHandles.Lookup> constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (Exception e) {
            LOGGER.error("failed to make MethodHandles.Lookup accessible, config proxy may not work", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean isJava8() {
        String version = ManagementFactory.getRuntimeMXBean().getSpecVersion();
        return version.startsWith("1.8");
    }

    private static Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (Config.isJava8()) {
            Constructor<MethodHandles.Lookup> constructor = Config.getConstructor();
            return constructor.newInstance(declaringClass, 2).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
        }
        MethodType rt = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return MethodHandles.lookup().findSpecial(declaringClass, method.getName(), rt, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    public static <T> T createProxy(Class<T> cls, Function<String, String> props) {
        Class[] interfaces = new Class[]{cls};
        return (T)Proxy.newProxyInstance(Config.classLoader(), interfaces, (proxy, method, args) -> {
            String name = method.getName();
            if (method.isDefault()) {
                return Config.invokeDefault(proxy, method, args);
            }
            if ("get".equals(method.getName())) {
                return props.apply((String)args[0]);
            }
            Class<?> rt = method.getReturnType();
            String v = (String)props.apply(name);
            if (v == null) {
                throw new NoSuchElementException("could not find value for config setting: " + name);
            }
            return Config.valueOf(rt, v);
        });
    }

    public static <T> T usingMap(Class<T> cls, Map<String, String> props) {
        return Config.createProxy(cls, props::get);
    }

    public static <T> T usingProperties(Class<T> cls, Properties props, String prefix) {
        return Config.createProxy(cls, k -> props.getProperty(prefix + k));
    }

    public static <T> T usingSystemProperties(Class<T> cls, String prefix) {
        return Config.createProxy(cls, k -> System.getProperty(prefix + k));
    }

    public static RegistryConfig usingMap(Map<String, String> props) {
        return Config.usingMap(RegistryConfig.class, props);
    }

    public static RegistryConfig usingProperties(Properties props, String prefix) {
        return Config.usingProperties(RegistryConfig.class, props, prefix);
    }

    public static RegistryConfig usingSystemProperties(String prefix) {
        return Config.usingSystemProperties(RegistryConfig.class, prefix);
    }

    public static RegistryConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }

    private static String get(String k) {
        return System.getProperty(k);
    }

    private static String get(String k, String dflt) {
        String v = Config.get(k);
        return v == null ? dflt : v;
    }

    public static boolean propagateWarnings() {
        return Boolean.valueOf(Config.get("spectator.api.propagateWarnings", "false"));
    }

    public static int maxNumberOfMeters() {
        String v = Config.get("spectator.api.maxNumberOfMeters");
        return v == null ? Integer.MAX_VALUE : Integer.parseInt(v);
    }

    static {
        PARSERS.put(Boolean.class, Boolean::valueOf);
        PARSERS.put(Boolean.TYPE, Boolean::valueOf);
        PARSERS.put(Byte.class, Byte::valueOf);
        PARSERS.put(Byte.TYPE, Byte::valueOf);
        PARSERS.put(Short.class, Short::valueOf);
        PARSERS.put(Short.TYPE, Short::valueOf);
        PARSERS.put(Integer.class, Integer::valueOf);
        PARSERS.put(Integer.TYPE, Integer::valueOf);
        PARSERS.put(Long.class, Long::valueOf);
        PARSERS.put(Long.TYPE, Long::valueOf);
        PARSERS.put(Float.class, Float::valueOf);
        PARSERS.put(Float.TYPE, Float::valueOf);
        PARSERS.put(Double.class, Double::valueOf);
        PARSERS.put(Double.TYPE, Double::valueOf);
        PARSERS.put(Character.class, s -> Character.valueOf(s.charAt(0)));
        PARSERS.put(Character.TYPE, s -> Character.valueOf(s.charAt(0)));
        PARSERS.put(String.class, s -> s);
        PARSERS.put(Duration.class, Duration::parse);
        PARSERS.put(Period.class, Period::parse);
        PARSERS.put(Instant.class, Instant::parse);
        PARSERS.put(ZonedDateTime.class, ZonedDateTime::parse);
        PARSERS.put(ZoneId.class, ZoneId::of);
        DEFAULT_CONFIG = Config.usingSystemProperties(PREFIX);
    }
}

