/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.Collection;
import java.util.Iterator;

final class CompositeDistributionSummary
extends CompositeMeter
implements DistributionSummary {
    CompositeDistributionSummary(Id id, Collection<Registry> registries) {
        super(id, registries);
    }

    @Override
    public void record(long amount) {
        for (Registry r : this.registries) {
            r.distributionSummary(this.id).record(amount);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? ((Registry)it.next()).distributionSummary(this.id).count() : 0L;
    }

    @Override
    public long totalAmount() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? ((Registry)it.next()).distributionSummary(this.id).totalAmount() : 0L;
    }
}

