/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;

final class CompositeDistributionSummary
extends CompositeMeter
implements DistributionSummary {
    private final DistributionSummary[] summaries;

    CompositeDistributionSummary(Id id, DistributionSummary[] summaries) {
        super(id);
        this.summaries = summaries;
    }

    @Override
    protected Meter[] meters() {
        return this.summaries;
    }

    @Override
    public void record(long amount) {
        for (DistributionSummary t : this.summaries) {
            t.record(amount);
        }
    }

    @Override
    public long count() {
        return this.summaries.length == 0 ? 0L : this.summaries[0].count();
    }

    @Override
    public long totalAmount() {
        return this.summaries.length == 0 ? 0L : this.summaries[0].totalAmount();
    }
}

