/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class CompositeTimer
extends CompositeMeter
implements Timer {
    private final Clock clock;
    private final Timer[] timers;

    CompositeTimer(Id id, Clock clock, Timer[] timers) {
        super(id);
        this.clock = clock;
        this.timers = timers;
    }

    @Override
    protected Meter[] meters() {
        return this.timers;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        for (Timer t : this.timers) {
            t.record(amount, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return this.timers.length == 0 ? 0L : this.timers[0].count();
    }

    @Override
    public long totalTime() {
        return this.timers.length == 0 ? 0L : this.timers[0].totalTime();
    }
}

