/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultDistributionSummary
implements DistributionSummary {
    private final Clock clock;
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalAmount;
    private final Id countId;
    private final Id totalAmountId;

    DefaultDistributionSummary(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalAmount = new AtomicLong(0L);
        this.countId = id.withTag("statistic", "count");
        this.totalAmountId = id.withTag("statistic", "totalAmount");
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        this.totalAmount.addAndGet(amount);
        this.count.incrementAndGet();
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(new Measurement(this.countId, now, this.count.get()));
        ms.add(new Measurement(this.totalAmountId, now, this.totalAmount.get()));
        return ms;
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public long totalAmount() {
        return this.totalAmount.get();
    }
}

