/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import spectator-agent.config.Config;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.jvm.JmxConfig;
import spectator-agent.spectator.jvm.JmxData;
import spectator-agent.spectator.jvm.JmxMeasurementConfig;

public class JmxPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxPoller.class);
    private final Registry registry;
    private List<JmxConfig> configs = Collections.emptyList();

    public JmxPoller(Registry registry) {
        this.registry = registry;
    }

    public void updateConfigs(List<? extends Config> configs) {
        this.configs = configs.stream().map(JmxConfig::from).collect(Collectors.toList());
    }

    public void poll() {
        for (JmxConfig config : this.configs) {
            try {
                for (JmxData data : JmxData.query(config.getQuery())) {
                    for (JmxMeasurementConfig cfg : config.getMeasurements()) {
                        cfg.measure(this.registry, data);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed to query jmx data: {}", (Object)config.getQuery().getCanonicalName(), (Object)e);
            }
        }
    }
}

