/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.impl.PatternMatcher;
import spectator-agent.spectator.impl.Preconditions;

public interface Query {
    public static final Query TRUE = new Query(){

        @Override
        public Query and(Query q) {
            return q;
        }

        @Override
        public Query or(Query q) {
            return TRUE;
        }

        @Override
        public Query not() {
            return FALSE;
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return true;
        }

        public String toString() {
            return ":true";
        }
    };
    public static final Query FALSE = new Query(){

        @Override
        public Query and(Query q) {
            return FALSE;
        }

        @Override
        public Query or(Query q) {
            return q;
        }

        @Override
        public Query not() {
            return TRUE;
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return false;
        }

        public String toString() {
            return ":false";
        }
    };

    public static Map<String, String> toMap(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            tags.put(t.key(), t.value());
        }
        tags.put("name", id.name());
        return tags;
    }

    public boolean matches(Map<String, String> var1);

    default public boolean matches(Id id) {
        return this.matches(Query.toMap(id));
    }

    default public Map<String, String> exactTags() {
        return Collections.emptyMap();
    }

    default public Query and(Query q) {
        return q == TRUE || q == FALSE ? q.and(this) : new And(this, q);
    }

    default public Query or(Query q) {
        return q == TRUE || q == FALSE ? q.or(this) : new Or(this, q);
    }

    default public Query not() {
        return this instanceof KeyQuery ? new InvertedKeyQuery((KeyQuery)this) : new Not(this);
    }

    default public List<Query> dnfList() {
        return Collections.singletonList(this);
    }

    default public List<Query> andList() {
        return Collections.singletonList(this);
    }

    default public Query simplify(Map<String, String> tags) {
        return this;
    }

    public static final class Regex
    implements KeyQuery {
        private final String k;
        private final String v;
        private final PatternMatcher pattern;
        private final String name;

        Regex(String k, String v) {
            this(k, v, false, ":re");
        }

        Regex(String k, String v, boolean ignoreCase, String name) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
            this.pattern = ignoreCase ? PatternMatcher.compile("^" + v).ignoreCase() : PatternMatcher.compile("^" + v);
            this.name = Preconditions.checkNotNull(name, "name");
        }

        @Override
        public String key() {
            return this.k;
        }

        public PatternMatcher pattern() {
            return this.pattern;
        }

        @Override
        public boolean matches(String value) {
            return value != null && this.pattern.matches(value);
        }

        public boolean alwaysMatches() {
            return this.pattern.alwaysMatches();
        }

        public String toString() {
            return this.k + "," + this.v + "," + this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Regex)) {
                return false;
            }
            Regex other = (Regex)obj;
            return this.k.equals(other.k) && this.v.equals(other.v) && this.pattern.equals(other.pattern) && this.name.equals(other.name);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            result = 31 * result + this.pattern.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }

    public static final class GreaterThanEqual
    implements KeyQuery {
        private final String k;
        private final String v;

        GreaterThanEqual(String k, String v) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            return value != null && value.compareTo(this.v) >= 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:ge";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GreaterThanEqual)) {
                return false;
            }
            GreaterThanEqual other = (GreaterThanEqual)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class GreaterThan
    implements KeyQuery {
        private final String k;
        private final String v;

        GreaterThan(String k, String v) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            return value != null && value.compareTo(this.v) > 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:gt";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GreaterThan)) {
                return false;
            }
            GreaterThan other = (GreaterThan)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class LessThanEqual
    implements KeyQuery {
        private final String k;
        private final String v;

        LessThanEqual(String k, String v) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            return value != null && value.compareTo(this.v) <= 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:le";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LessThanEqual)) {
                return false;
            }
            LessThanEqual other = (LessThanEqual)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class LessThan
    implements KeyQuery {
        private final String k;
        private final String v;

        LessThan(String k, String v) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            return value != null && value.compareTo(this.v) < 0;
        }

        public String toString() {
            return this.k + "," + this.v + ",:lt";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LessThan)) {
                return false;
            }
            LessThan other = (LessThan)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class In
    implements KeyQuery {
        private final String k;
        private final Set<String> vs;
        private final int cachedHashCode;

        In(String k, Set<String> vs) {
            Preconditions.checkArg(!vs.isEmpty(), "list of values for :in cannot be empty");
            this.k = Preconditions.checkNotNull(k, "k");
            this.vs = Preconditions.checkNotNull(vs, "vs");
            this.cachedHashCode = this.calculateHashCode();
        }

        @Override
        public String key() {
            return this.k;
        }

        public Set<String> values() {
            return this.vs;
        }

        @Override
        public boolean matches(String value) {
            return value != null && this.vs.contains(value);
        }

        @Override
        public List<Query> dnfList() {
            if ("name".equals(this.k) || this.vs.size() <= 5) {
                ArrayList<Query> queries = new ArrayList<Query>(this.vs.size());
                for (String v : this.vs) {
                    queries.add(new Equal(this.k, v));
                }
                return queries;
            }
            return Collections.singletonList(this);
        }

        public String toString() {
            String values = String.join((CharSequence)",", this.vs);
            return this.k + ",(," + values + ",),:in";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof In)) {
                return false;
            }
            In other = (In)obj;
            return this.k.equals(other.k) && this.vs.equals(other.vs);
        }

        public int hashCode() {
            return this.cachedHashCode;
        }

        private int calculateHashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.vs.hashCode();
            return result;
        }
    }

    public static final class Equal
    implements KeyQuery {
        private final String k;
        private final String v;

        Equal(String k, String v) {
            this.k = Preconditions.checkNotNull(k, "k");
            this.v = Preconditions.checkNotNull(v, "v");
        }

        @Override
        public String key() {
            return this.k;
        }

        public String value() {
            return this.v;
        }

        @Override
        public boolean matches(String value) {
            return this.v.equals(value);
        }

        @Override
        public Map<String, String> exactTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put(this.k, this.v);
            return tags;
        }

        public String toString() {
            return this.k + "," + this.v + ",:eq";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Equal)) {
                return false;
            }
            Equal other = (Equal)obj;
            return this.k.equals(other.k) && this.v.equals(other.v);
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.v.hashCode();
            return result;
        }
    }

    public static final class Has
    implements KeyQuery {
        private final String k;

        Has(String k) {
            this.k = Preconditions.checkNotNull(k, "k");
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            return value != null;
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return tags.containsKey(this.k);
        }

        public String toString() {
            return this.k + ",:has";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Has)) {
                return false;
            }
            Has other = (Has)obj;
            return this.k.equals(other.k);
        }

        public int hashCode() {
            return this.k.hashCode();
        }
    }

    public static final class InvertedKeyQuery
    implements KeyQuery {
        private final KeyQuery q;

        InvertedKeyQuery(KeyQuery q) {
            this.q = Preconditions.checkNotNull(q, "q");
        }

        @Override
        public Query not() {
            return this.q;
        }

        @Override
        public String key() {
            return this.q.key();
        }

        @Override
        public boolean matches(String value) {
            return !this.q.matches(value);
        }

        @Override
        public Query simplify(Map<String, String> tags) {
            Query sq = this.q.simplify(tags);
            return sq != this.q ? sq.not() : this;
        }

        public String toString() {
            return this.q + ",:not";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InvertedKeyQuery)) {
                return false;
            }
            InvertedKeyQuery other = (InvertedKeyQuery)obj;
            return this.q.equals(other.q);
        }

        public int hashCode() {
            return this.q.hashCode();
        }
    }

    public static final class CompositeKeyQuery
    implements KeyQuery {
        private final String k;
        private final List<KeyQuery> queries;

        CompositeKeyQuery(KeyQuery query) {
            Preconditions.checkNotNull(query, "query");
            this.k = query.key();
            this.queries = new ArrayList<KeyQuery>();
            this.queries.add(query);
        }

        void add(KeyQuery query) {
            Preconditions.checkArg(this.k.equals(query.key()), "key mismatch: " + this.k + " != " + query.key());
            this.queries.add(query);
        }

        @Override
        public String key() {
            return this.k;
        }

        @Override
        public boolean matches(String value) {
            for (KeyQuery kq : this.queries) {
                if (kq.matches(value)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (KeyQuery kq : this.queries) {
                if (first) {
                    first = false;
                    builder.append(kq);
                    continue;
                }
                builder.append(',').append(kq).append(",:and");
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKeyQuery that = (CompositeKeyQuery)o;
            return Objects.equals(this.queries, that.queries) && Objects.equals(this.k, that.k);
        }

        public int hashCode() {
            return Objects.hash(this.queries, this.k);
        }
    }

    public static interface KeyQuery
    extends Query {
        public String key();

        public boolean matches(String var1);

        @Override
        default public boolean matches(Map<String, String> tags) {
            return this.matches(tags.get(this.key()));
        }

        @Override
        default public Query simplify(Map<String, String> tags) {
            String v = tags.get(this.key());
            if (v == null) {
                return this;
            }
            return this.matches(v) ? TRUE : FALSE;
        }
    }

    public static final class Not
    implements Query {
        private final Query q;

        Not(Query q) {
            this.q = Preconditions.checkNotNull(q, "q");
        }

        @Override
        public Query not() {
            return this.q;
        }

        @Override
        public List<Query> dnfList() {
            if (this.q instanceof And) {
                And query = (And)this.q;
                ArrayList<Query> qs = new ArrayList<Query>(query.q1.not().dnfList());
                qs.addAll(query.q2.not().dnfList());
                return qs;
            }
            if (this.q instanceof Or) {
                Or query = (Or)this.q;
                Query q1 = query.q1.not();
                Query q2 = query.q2.not();
                return q1.and(q2).dnfList();
            }
            return Collections.singletonList(this);
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return !this.q.matches(tags);
        }

        @Override
        public Query simplify(Map<String, String> tags) {
            Query sq = this.q.simplify(tags);
            return sq != this.q ? sq.not() : this;
        }

        public String toString() {
            return this.q + ",:not";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Not)) {
                return false;
            }
            Not other = (Not)obj;
            return this.q.equals(other.q);
        }

        public int hashCode() {
            return this.q.hashCode();
        }
    }

    public static final class Or
    implements Query {
        private final Query q1;
        private final Query q2;

        Or(Query q1, Query q2) {
            this.q1 = Preconditions.checkNotNull(q1, "q1");
            this.q2 = Preconditions.checkNotNull(q2, "q2");
        }

        @Override
        public Query not() {
            Query nq1 = this.q1.not();
            Query nq2 = this.q2.not();
            return nq1.and(nq2);
        }

        @Override
        public List<Query> dnfList() {
            ArrayList<Query> qs = new ArrayList<Query>(this.q1.dnfList());
            qs.addAll(this.q2.dnfList());
            return qs;
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return this.q1.matches(tags) || this.q2.matches(tags);
        }

        @Override
        public Query simplify(Map<String, String> tags) {
            Query sq1 = this.q1.simplify(tags);
            Query sq2 = this.q2.simplify(tags);
            return sq1 != this.q1 || sq2 != this.q2 ? sq1.or(sq2) : this;
        }

        public String toString() {
            return this.q1 + "," + this.q2 + ",:or";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Or)) {
                return false;
            }
            Or other = (Or)obj;
            return this.q1.equals(other.q1) && this.q2.equals(other.q2);
        }

        public int hashCode() {
            int result = this.q1.hashCode();
            result = 31 * result + this.q2.hashCode();
            return result;
        }
    }

    public static final class And
    implements Query {
        private final Query q1;
        private final Query q2;

        And(Query q1, Query q2) {
            this.q1 = Preconditions.checkNotNull(q1, "q1");
            this.q2 = Preconditions.checkNotNull(q2, "q2");
        }

        @Override
        public Query not() {
            Query nq1 = this.q1.not();
            Query nq2 = this.q2.not();
            return nq1.or(nq2);
        }

        @Override
        public List<Query> dnfList() {
            return this.crossAnd(this.q1.dnfList(), this.q2.dnfList());
        }

        @Override
        public List<Query> andList() {
            ArrayList<Query> tmp = new ArrayList<Query>(this.q1.andList());
            tmp.addAll(this.q2.andList());
            return tmp;
        }

        private List<Query> crossAnd(List<Query> qs1, List<Query> qs2) {
            ArrayList<Query> tmp = new ArrayList<Query>();
            for (Query q1 : qs1) {
                for (Query q2 : qs2) {
                    tmp.add(q1.and(q2));
                }
            }
            return tmp;
        }

        @Override
        public boolean matches(Map<String, String> tags) {
            return this.q1.matches(tags) && this.q2.matches(tags);
        }

        @Override
        public Map<String, String> exactTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.putAll(this.q1.exactTags());
            tags.putAll(this.q2.exactTags());
            return tags;
        }

        @Override
        public Query simplify(Map<String, String> tags) {
            Query sq1 = this.q1.simplify(tags);
            Query sq2 = this.q2.simplify(tags);
            return sq1 != this.q1 || sq2 != this.q2 ? sq1.and(sq2) : this;
        }

        public String toString() {
            return this.q1 + "," + this.q2 + ",:and";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof And)) {
                return false;
            }
            And other = (And)obj;
            return this.q1.equals(other.q1) && this.q2.equals(other.q2);
        }

        public int hashCode() {
            int result = this.q1.hashCode();
            result = 31 * result + this.q2.hashCode();
            return result;
        }
    }
}

