/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.AtomicDouble;

class AtlasGauge
extends AtlasMeter
implements Gauge {
    private final AtomicDouble value = new AtomicDouble(0.0);
    private final Id stat;

    AtlasGauge(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = AtlasMeter.addIfMissing(id, Statistic.gauge, DsType.gauge);
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double v = this.value();
        if (Double.isFinite(v)) {
            consumer.accept(this.stat, this.clock.wallTime(), v);
        }
    }

    @Override
    public void set(double v) {
        this.value.set(v);
        this.updateLastModTime(this.clock.wallTime());
    }

    @Override
    public double value() {
        return this.value.get();
    }
}

