/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.CompositeMeter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Timer;

final class CompositeTimer
extends CompositeMeter<Timer>
implements Timer {
    private final Clock clock;

    CompositeTimer(Id id, Clock clock, Collection<Timer> timers) {
        super(id, timers);
        this.clock = clock;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        for (Timer t : this.meters) {
            t.record(amount, unit);
        }
    }

    @Override
    public long count() {
        Iterator it = this.meters.iterator();
        return it.hasNext() ? ((Timer)it.next()).count() : 0L;
    }

    @Override
    public long totalTime() {
        Iterator it = this.meters.iterator();
        return it.hasNext() ? ((Timer)it.next()).totalTime() : 0L;
    }
}

