/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.databind.JavaType;
import spectator-agent.json.jackson.databind.JsonMappingException;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.json.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import spectator-agent.json.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import spectator-agent.json.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spectator-agent.json.jackson.databind.ser.std.StdScalarSerializer;
import spectator-agent.json.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

