/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl;

import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.impl.StepValue;

public class StepLong
implements StepValue {
    private final long init;
    private final Clock clock;
    private final long step;
    private volatile long previous;
    private final AtomicLong current;
    private final AtomicLong lastInitPos;

    public StepLong(long init, Clock clock, long step) {
        this.init = init;
        this.clock = clock;
        this.step = step;
        this.previous = init;
        this.current = new AtomicLong(init);
        this.lastInitPos = new AtomicLong(clock.wallTime() / step);
    }

    private void rollCount(long now) {
        long stepTime = now / this.step;
        long lastInit = this.lastInitPos.get();
        if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
            long v = this.current.getAndSet(this.init);
            this.previous = lastInit == stepTime - 1L ? v : this.init;
        }
    }

    public AtomicLong getCurrent() {
        return this.getCurrent(this.clock.wallTime());
    }

    public AtomicLong getCurrent(long now) {
        this.rollCount(now);
        return this.current;
    }

    public long poll() {
        return this.poll(this.clock.wallTime());
    }

    public long poll(long now) {
        this.rollCount(now);
        return this.previous;
    }

    @Override
    public double pollAsRate() {
        return this.pollAsRate(this.clock.wallTime());
    }

    @Override
    public double pollAsRate(long now) {
        long amount = this.poll(now);
        double period = (double)this.step / 1000.0;
        return (double)amount / period;
    }

    @Override
    public long timestamp() {
        return this.lastInitPos.get() * this.step;
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", previous=" + this.previous + ", current=" + this.current.get() + ", lastInitPos=" + this.lastInitPos.get() + '}';
    }
}

