/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc.http;

import java.util.Collections;
import java.util.Set;
import spectator-agent.spectator.impl.AsciiSet;

public final class PathSanitizer {
    private static final int MAX_LENGTH = 120;
    private static final AsciiSet ALPHA_CHARS = AsciiSet.fromPattern("a-zA-Z");
    private static final AsciiSet DIGITS = AsciiSet.fromPattern("0-9");
    private static final AsciiSet CONSONANTS = AsciiSet.fromPattern("b-df-hj-np-tv-xzB-DF-HJ-NP-TV-XZ");

    private PathSanitizer() {
    }

    public static String sanitize(String path) {
        return PathSanitizer.sanitizeSegments(PathSanitizer.removeParameters(path), Collections.emptySet());
    }

    public static String sanitize(String path, Set<String> allowed) {
        return PathSanitizer.sanitizeSegments(PathSanitizer.removeParameters(path), allowed);
    }

    private static String removeParameters(String path) {
        return PathSanitizer.removeParameters(PathSanitizer.removeParameters(path, '?'), ';');
    }

    private static String removeParameters(String path, char c) {
        int i = path.indexOf(c);
        return i > 0 ? path.substring(0, i) : path;
    }

    private static String sanitizeSegments(String path, Set<String> allowed) {
        StringBuilder builder = new StringBuilder();
        int length = path.length();
        int pos = path.charAt(0) == '/' ? 1 : 0;
        int segmentsAdded = 0;
        while (pos < length && segmentsAdded < 5) {
            String segment;
            int e = path.indexOf(47, pos);
            if (e > 0) {
                segment = path.substring(pos, e);
                pos = e + 1;
            } else {
                segment = path.substring(pos);
                pos = length;
            }
            if (segment.isEmpty()) continue;
            if (PathSanitizer.shouldSuppressSegment(segment, allowed)) {
                PathSanitizer.appendIfSpaceAvailable(builder, "-");
            } else {
                PathSanitizer.appendIfSpaceAvailable(builder, segment);
            }
            ++segmentsAdded;
        }
        return builder.toString();
    }

    private static boolean shouldSuppressSegment(String segment, Set<String> allowed) {
        if ("graphql".equals(segment) || allowed.contains(segment)) {
            return false;
        }
        int maxSequentialConsonants = 4;
        int sequentialConsonants = 0;
        boolean version = false;
        boolean allAlpha = true;
        int n = segment.length();
        for (int i = 0; i < n; ++i) {
            char c = segment.charAt(i);
            if (CONSONANTS.contains(c)) {
                if (++sequentialConsonants >= 4) {
                    return true;
                }
            } else {
                sequentialConsonants = 0;
            }
            version = i == 0 && c == 'v' ? true : (version &= DIGITS.contains(c));
            if (version || (allAlpha &= ALPHA_CHARS.contains(c))) continue;
            return true;
        }
        return !version && n == 2;
    }

    private static void appendIfSpaceAvailable(StringBuilder builder, String segment) {
        int spaceRemaining = 120 - builder.length() - 1;
        if (segment.length() < spaceRemaining) {
            builder.append('_').append(segment);
        } else if (spaceRemaining >= 2) {
            builder.append("_-");
        }
    }
}

