/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import spectator-agent.spectator.impl.PatternExpr;
import spectator-agent.spectator.impl.PatternMatcher;
import spectator-agent.spectator.impl.matcher.IgnoreCaseMatcher;
import spectator-agent.spectator.impl.matcher.Optimizer;
import spectator-agent.spectator.impl.matcher.PatternUtils;

interface Matcher
extends PatternMatcher {
    public int matches(String var1, int var2, int var3);

    @Override
    default public boolean matches(String str) {
        return this.matches(str, 0, str.length()) >= 0;
    }

    @Override
    default public PatternMatcher ignoreCase() {
        Matcher m = this.rewrite(PatternUtils::ignoreCase);
        return new IgnoreCaseMatcher(m);
    }

    @Override
    default public List<PatternMatcher> expandOrClauses(int max) {
        List<Matcher> ms = PatternUtils.expandOrClauses(this, max);
        if (ms == null) {
            return null;
        }
        ArrayList<PatternMatcher> results = new ArrayList<PatternMatcher>(ms.size());
        for (Matcher m : ms) {
            results.add(Optimizer.optimize(m));
        }
        return results;
    }

    @Override
    default public PatternExpr toPatternExpr(int max) {
        return PatternUtils.toPatternExpr(this, max);
    }

    @Override
    default public String toSqlPattern() {
        return PatternUtils.toSqlPattern(this);
    }

    default public <T> T as() {
        return (T)this;
    }

    default public Matcher rewrite(Function<Matcher, Matcher> f) {
        return f.apply(this);
    }

    default public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return f.apply(this);
    }
}

