/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import spectator-agent.spectator.api.BasicTag;
import spectator-agent.spectator.api.Tag;

public class TagsBuilder<T extends TagsBuilder<T>> {
    protected final List<Tag> extraTags = new ArrayList<Tag>();

    protected TagsBuilder() {
    }

    public T withTag(String k, String v) {
        this.extraTags.add(new BasicTag(k, v));
        return (T)this;
    }

    public T withTag(String k, Boolean v) {
        return this.withTag(k, Boolean.toString(v));
    }

    public <E extends Enum<E>> T withTag(String k, Enum<E> v) {
        return this.withTag(k, v.name());
    }

    public T withTag(Tag t) {
        this.extraTags.add(t);
        return (T)this;
    }

    public T withTags(String ... tags) {
        for (int i = 0; i < tags.length; i += 2) {
            this.extraTags.add(new BasicTag(tags[i], tags[i + 1]));
        }
        return (T)this;
    }

    public T withTags(Tag ... tags) {
        Collections.addAll(this.extraTags, tags);
        return (T)this;
    }

    public T withTags(Iterable<Tag> tags) {
        for (Tag t : tags) {
            this.extraTags.add(t);
        }
        return (T)this;
    }

    public T withTags(Map<String, String> tags) {
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.extraTags.add(new BasicTag(entry.getKey(), entry.getValue()));
        }
        return (T)this;
    }
}

