/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.DoubleFunction;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.impl.Preconditions;

public final class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);
    public static final DoubleFunction<? extends Number> IDENTITY = new DoubleFunction<Number>(){

        @Override
        public double apply(double v) {
            return v;
        }
    };
    public static final DoubleFunction<AtomicLong> AGE = Functions.age(Clock.SYSTEM);

    private Functions() {
    }

    public static DoubleFunction<AtomicLong> age(final Clock clock) {
        return new DoubleFunction<AtomicLong>(){

            @Override
            public double apply(double t) {
                return ((double)clock.wallTime() - t) / 1000.0;
            }
        };
    }

    public static <T> ToDoubleFunction<T> invokeMethod(Method method) {
        method.setAccessible(true);
        return obj -> {
            try {
                Number n = (Number)method.invoke(obj, new Object[0]);
                return n.doubleValue();
            }
            catch (Exception e) {
                LOGGER.warn("exception from method registered as a gauge [" + method + "]", e);
                return Double.NaN;
            }
        };
    }

    public static Predicate<Meter> nameEquals(String name) {
        Preconditions.checkNotNull(name, "name");
        return m -> name.equals(m.id().name());
    }
}

