/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.core.JsonGenerator;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.core.JsonToken;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.core.type.WritableTypeId;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.JavaType;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.JsonMappingException;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.JsonNode;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.SerializerProvider;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.annotation.JacksonStdImpl;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatTypes;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.jsontype.TypeSerializer;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.node.ObjectNode;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

