/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.concurrent.TimeUnit;
import spectator-agent.spectator.api.Timer;

final class TimerBatchUpdater
implements Timer.BatchUpdater {
    private final Timer timer;
    private final int batchSize;
    private int count;
    private final long[] amounts;

    TimerBatchUpdater(Timer timer, int batchSize) {
        this.timer = timer;
        this.batchSize = batchSize;
        this.count = 0;
        this.amounts = new long[batchSize];
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.amounts[this.count++] = unit.toNanos(amount);
            if (this.count >= this.batchSize) {
                this.flush();
            }
        }
    }

    @Override
    public void flush() {
        this.timer.record(this.amounts, this.count, TimeUnit.NANOSECONDS);
        this.count = 0;
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }
}

