/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.impl.SwapMeter;

final class SwapTimer
extends SwapMeter<Timer>
implements Timer {
    SwapTimer(Registry registry, LongSupplier versionSupplier, Id id, Timer underlying) {
        super(registry, versionSupplier, id, underlying);
    }

    @Override
    public Timer lookup() {
        return this.registry.timer(this.id);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        ((Timer)this.get()).record(amount, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.registry.clock().monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.registry.clock().monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.registry.clock().monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.registry.clock().monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return ((Timer)this.get()).count();
    }

    @Override
    public long totalTime() {
        return ((Timer)this.get()).totalTime();
    }

    @Override
    public Timer.BatchUpdater batchUpdater(int batchSize) {
        Timer.BatchUpdater updater = ((Timer)this.get()).batchUpdater(batchSize);
        if (updater instanceof Consumer) {
            ((Consumer)((Object)updater)).accept(this::get);
        }
        return updater;
    }
}

