/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.nflx.tagging;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class NetflixTagging {
    private static final Set DEFAULT_ATLAS_TAG_KEYS;

    private NetflixTagging() {
    }

    private static String fixTagString(String str) {
        return str.replaceAll("[^-._A-Za-z0-9~^]", "_");
    }

    private static Map<String, String> fixTagStrings(Map<String, String> tags) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            result.put(NetflixTagging.fixTagString(entry.getKey()), NetflixTagging.fixTagString(entry.getValue()));
        }
        return result;
    }

    public static Map<String, String> commonTags() {
        return NetflixTagging.commonTags(System::getenv);
    }

    public static Map<String, String> commonTags(Function<String, String> getenv) {
        HashMap<String, String> tags = new HashMap<String, String>();
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.account", "NETFLIX_ACCOUNT_ID", "EC2_OWNER_ID");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.ami", "EC2_AMI_ID");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.app", "NETFLIX_APP");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.asg", "NETFLIX_AUTO_SCALE_GROUP");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.cluster", "NETFLIX_CLUSTER");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.container", "TITUS_CONTAINER_NAME");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.node", "NETFLIX_INSTANCE_ID", "TITUS_TASK_INSTANCE_ID", "EC2_INSTANCE_ID");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.process", "NETFLIX_PROCESS_NAME");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.region", "NETFLIX_REGION", "EC2_REGION");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.shard1", "NETFLIX_SHARD1");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.shard2", "NETFLIX_SHARD2");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.stack", "NETFLIX_STACK");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.vmtype", "EC2_INSTANCE_TYPE");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "nf.zone", "EC2_AVAILABILITY_ZONE");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "accountType", "NETFLIX_ACCOUNT_TYPE");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "buildUrl", "NETFLIX_BUILD_JOB");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "sourceRepo", "NETFLIX_BUILD_SOURCE_REPO");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "branch", "NETFLIX_BUILD_BRANCH");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "commit", "NETFLIX_BUILD_COMMIT");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisJobName", "MANTIS_JOB_NAME");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisJobId", "MANTIS_JOB_ID");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisWorkerIndex", "MANTIS_WORKER_INDEX");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisWorkerNumber", "MANTIS_WORKER_NUMBER");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisWorkerStageNumber", "MANTIS_WORKER_STAGE_NUMBER");
        NetflixTagging.putIfNotEmptyOrNull(getenv, tags, "mantisUser", "MANTIS_USER");
        return tags;
    }

    public static Map<String, String> commonTagsForAtlas() {
        return NetflixTagging.commonTagsForAtlas(System::getenv);
    }

    public static Map<String, String> commonTagsForAtlas(Function<String, String> getenv) {
        return NetflixTagging.fixTagStrings(NetflixTagging.commonTagsForAtlas(getenv, NetflixTagging.defaultAtlasKeyPredicate(getenv)));
    }

    public static Map<String, String> commonTagsForAtlas(Function<String, String> getenv, Predicate<String> keyPredicate) {
        Map<String, String> tags = NetflixTagging.commonTags(getenv);
        tags.keySet().removeIf(keyPredicate.negate());
        return tags;
    }

    public static Predicate<String> defaultAtlasKeyPredicate(Function<String, String> getenv) {
        Predicate<String> skipPredicate = NetflixTagging.atlasSkipTagsPredicate(getenv);
        return k -> DEFAULT_ATLAS_TAG_KEYS.contains(k) && skipPredicate.test((String)k);
    }

    public static Predicate<String> atlasSkipTagsPredicate(Function<String, String> getenv) {
        Set<String> tagsToSkip = NetflixTagging.parseAtlasSkipTags(getenv);
        return k -> !tagsToSkip.contains(k);
    }

    private static boolean isEmptyOrNull(String s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void putIfNotEmptyOrNull(Function<String, String> getenv, Map<String, String> tags, String key, String ... envVars) {
        for (String envVar : envVars) {
            String value = getenv.apply(envVar);
            if (NetflixTagging.isEmptyOrNull(value)) continue;
            tags.put(key, value.trim());
            break;
        }
    }

    private static Set<String> parseAtlasSkipTags(Function<String, String> getenv) {
        return NetflixTagging.parseAtlasSkipTags(getenv.apply("ATLAS_SKIP_COMMON_TAGS"));
    }

    private static Set<String> parseAtlasSkipTags(String skipTags) {
        String[] parts;
        if (NetflixTagging.isEmptyOrNull(skipTags)) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String s : parts = skipTags.split(",")) {
            if (NetflixTagging.isEmptyOrNull(s)) continue;
            set.add(s.trim());
        }
        return set;
    }

    static {
        HashSet<String> tagKeys = new HashSet<String>();
        tagKeys.add("mantisJobId");
        tagKeys.add("mantisJobName");
        tagKeys.add("mantisUser");
        tagKeys.add("mantisWorkerIndex");
        tagKeys.add("mantisWorkerNumber");
        tagKeys.add("mantisWorkerStageNumber");
        tagKeys.add("nf.account");
        tagKeys.add("nf.app");
        tagKeys.add("nf.asg");
        tagKeys.add("nf.cluster");
        tagKeys.add("nf.container");
        tagKeys.add("nf.node");
        tagKeys.add("nf.process");
        tagKeys.add("nf.region");
        tagKeys.add("nf.shard1");
        tagKeys.add("nf.shard2");
        tagKeys.add("nf.stack");
        tagKeys.add("nf.vmtype");
        tagKeys.add("nf.zone");
        DEFAULT_ATLAS_TAG_KEYS = Collections.unmodifiableSet(tagKeys);
    }
}

