/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.StepDouble;

class AtlasMaxGauge
extends AtlasMeter
implements Gauge {
    private final StepDouble value;
    private final Id stat;

    AtlasMaxGauge(Registry registry, Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(Double.NaN, clock, step);
        this.stat = registry.createId(id.name()).withTag(Statistic.max).withTag(DsType.gauge).withTags(id.tags());
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double v = this.value.poll(now);
        if (Double.isFinite(v)) {
            consumer.accept(this.stat, this.value.timestamp(), v);
        }
    }

    @Override
    public void set(double v) {
        long now = this.clock.wallTime();
        this.value.getCurrent(now).max(v);
        this.updateLastModTime(now);
    }

    @Override
    public double value() {
        return this.value.poll();
    }
}

