/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.histogram;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongFunction;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.api.Utils;

public final class BucketTimer
implements Timer {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;
    private final ConcurrentHashMap<String, Timer> timers;
    private final Function<String, Timer> timerFactory;

    public static BucketTimer get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketTimer(registry, id, f);
    }

    BucketTimer(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
        this.timers = new ConcurrentHashMap();
        this.timerFactory = k -> registry.timer(id.withTag("bucket", (String)k));
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = unit.toNanos(amount);
        this.timer(this.f.apply(nanos)).record(amount, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> rf) throws Exception {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            T t = rf.call();
            return t;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable rf) {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            rf.run();
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    Timer timer(String bucket) {
        return Utils.computeIfAbsent(this.timers, bucket, this.timerFactory);
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalTime() {
        return 0L;
    }
}

