/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.impl.AtomicDouble;

final class DefaultCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble count;

    DefaultCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicDouble(0.0);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        double v = this.count.get();
        return Collections.singleton(new Measurement(this.id, now, v));
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.count.addAndGet(amount);
        }
    }

    @Override
    public double actualCount() {
        return this.count.get();
    }
}

