/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import spectator-agent.slf4j.MDC;
import spectator-agent.slf4j.Marker;
import spectator-agent.slf4j.event.Level;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.histogram.PercentileTimer;
import spectator-agent.spectator.ipc.IpcAttempt;
import spectator-agent.spectator.ipc.IpcAttemptFinal;
import spectator-agent.spectator.ipc.IpcErrorGroup;
import spectator-agent.spectator.ipc.IpcLogger;
import spectator-agent.spectator.ipc.IpcMetric;
import spectator-agent.spectator.ipc.IpcProtocol;
import spectator-agent.spectator.ipc.IpcResult;
import spectator-agent.spectator.ipc.IpcStatus;
import spectator-agent.spectator.ipc.IpcTagKey;
import spectator-agent.spectator.ipc.NetflixHeader;
import spectator-agent.spectator.ipc.ServerGroup;
import spectator-agent.spectator.ipc.http.PathSanitizer;

public final class IpcLogEntry {
    private final Clock clock;
    private Registry registry;
    private IpcLogger logger;
    private Level level;
    private Marker marker;
    private long startNanos;
    private long startTime;
    private long latency;
    private String owner;
    private IpcResult result;
    private String protocol;
    private IpcStatus status;
    private String statusDetail;
    private Throwable exception;
    private IpcAttempt attempt;
    private IpcAttemptFinal attemptFinal;
    private String vip;
    private String endpoint;
    private String clientRegion;
    private String clientZone;
    private String clientApp;
    private String clientCluster;
    private String clientAsg;
    private String clientNode;
    private String serverRegion;
    private String serverZone;
    private String serverApp;
    private String serverCluster;
    private String serverAsg;
    private String serverNode;
    private String httpMethod;
    private int httpStatus;
    private String uri;
    private String path;
    private long requestContentLength = -1L;
    private long responseContentLength = -1L;
    private final List<Header> requestHeaders = new ArrayList<Header>();
    private final List<Header> responseHeaders = new ArrayList<Header>();
    private String remoteAddress;
    private int remotePort;
    private final Map<String, String> additionalTags = new HashMap<String, String>();
    private final StringBuilder builder = new StringBuilder();
    private Id inflightId;

    IpcLogEntry(Clock clock) {
        this.clock = clock;
        this.reset();
    }

    IpcLogEntry withRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    IpcLogEntry withLogger(IpcLogger logger) {
        this.logger = logger;
        return this;
    }

    IpcLogEntry withMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    public IpcLogEntry withLogLevel(Level level) {
        this.level = level;
        return this;
    }

    public IpcLogEntry withLatency(long latency, TimeUnit unit) {
        this.latency = unit.toNanos(latency);
        return this;
    }

    public IpcLogEntry markStart() {
        if (this.registry != null) {
            this.inflightId = this.getInflightId();
            int n = this.logger.inflightRequests(this.inflightId).incrementAndGet();
            this.registry.distributionSummary(this.inflightId).record(n);
        }
        this.startTime = this.clock.wallTime();
        this.startNanos = this.clock.monotonicTime();
        return this;
    }

    public IpcLogEntry markEnd() {
        return this.withLatency(this.clock.monotonicTime() - this.startNanos, TimeUnit.NANOSECONDS);
    }

    public IpcLogEntry withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public IpcLogEntry withProtocol(IpcProtocol protocol) {
        return this.withProtocol(protocol.value());
    }

    public IpcLogEntry withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public IpcLogEntry withResult(IpcResult result) {
        this.result = result;
        return this;
    }

    public IpcLogEntry withStatus(IpcStatus status) {
        this.status = status;
        return this;
    }

    public IpcLogEntry withStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
        return this;
    }

    @Deprecated
    public IpcLogEntry withErrorGroup(IpcErrorGroup errorGroup) {
        return this;
    }

    @Deprecated
    public IpcLogEntry withErrorReason(String errorReason) {
        return this;
    }

    public IpcLogEntry withException(Throwable exception) {
        this.exception = exception;
        if (this.statusDetail == null) {
            this.statusDetail = exception.getClass().getSimpleName();
        }
        if (this.status == null) {
            this.status = IpcStatus.forException(exception);
        }
        return this;
    }

    public IpcLogEntry withAttempt(IpcAttempt attempt) {
        this.attempt = attempt;
        return this;
    }

    public IpcLogEntry withAttempt(int attempt) {
        return this.withAttempt(IpcAttempt.forAttemptNumber(attempt));
    }

    public IpcLogEntry withAttemptFinal(boolean isFinal) {
        this.attemptFinal = IpcAttemptFinal.forValue(isFinal);
        return this;
    }

    public IpcLogEntry withVip(String vip) {
        this.vip = vip;
        return this;
    }

    public IpcLogEntry withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public IpcLogEntry withClientRegion(String region) {
        this.clientRegion = region;
        return this;
    }

    public IpcLogEntry withClientZone(String zone) {
        this.clientZone = zone;
        if (this.clientRegion == null) {
            this.clientRegion = this.extractRegionFromZone(zone);
        }
        return this;
    }

    public IpcLogEntry withClientApp(String app) {
        this.clientApp = app;
        return this;
    }

    public IpcLogEntry withClientCluster(String cluster) {
        this.clientCluster = cluster;
        return this;
    }

    public IpcLogEntry withClientAsg(String asg) {
        this.clientAsg = asg;
        if (this.clientApp == null || this.clientCluster == null) {
            ServerGroup group = ServerGroup.parse(asg);
            this.clientApp = this.clientApp == null ? group.app() : this.clientApp;
            this.clientCluster = this.clientCluster == null ? group.cluster() : this.clientCluster;
        }
        return this;
    }

    public IpcLogEntry withClientNode(String node) {
        this.clientNode = node;
        return this;
    }

    public IpcLogEntry withServerRegion(String region) {
        this.serverRegion = region;
        return this;
    }

    public IpcLogEntry withServerZone(String zone) {
        this.serverZone = zone;
        if (this.serverRegion == null) {
            this.serverRegion = this.extractRegionFromZone(zone);
        }
        return this;
    }

    public IpcLogEntry withServerApp(String app) {
        this.serverApp = app;
        return this;
    }

    public IpcLogEntry withServerCluster(String cluster) {
        this.serverCluster = cluster;
        return this;
    }

    public IpcLogEntry withServerAsg(String asg) {
        this.serverAsg = asg;
        if (this.serverApp == null || this.serverCluster == null) {
            ServerGroup group = ServerGroup.parse(asg);
            this.serverApp = this.serverApp == null ? group.app() : this.serverApp;
            this.serverCluster = this.serverCluster == null ? group.cluster() : this.serverCluster;
        }
        return this;
    }

    public IpcLogEntry withServerNode(String node) {
        this.serverNode = node;
        return this;
    }

    public IpcLogEntry withHttpMethod(String method) {
        this.httpMethod = method;
        return this;
    }

    public IpcLogEntry withHttpStatus(int httpStatus) {
        if (httpStatus >= 100 && httpStatus < 600) {
            this.httpStatus = httpStatus;
            if (this.status == null) {
                this.status = IpcStatus.forHttpStatus(httpStatus);
            }
            if (this.result == null) {
                this.result = this.status.result();
            }
        } else {
            this.httpStatus = -1;
        }
        return this;
    }

    public IpcLogEntry withUri(String uri, String path) {
        this.uri = uri;
        this.path = path;
        return this;
    }

    public IpcLogEntry withUri(URI uri) {
        return this.withUri(uri.toString(), uri.getPath());
    }

    public IpcLogEntry withRequestContentLength(long length) {
        this.requestContentLength = length;
        return this;
    }

    public IpcLogEntry withResponseContentLength(long length) {
        this.responseContentLength = length;
        return this;
    }

    public IpcLogEntry addRequestHeader(String name, String value) {
        if (this.clientAsg == null && name.equalsIgnoreCase(NetflixHeader.ASG.headerName())) {
            this.withClientAsg(value);
        } else if (this.clientZone == null && name.equalsIgnoreCase(NetflixHeader.Zone.headerName())) {
            this.withClientZone(value);
        } else if (this.clientNode == null && name.equalsIgnoreCase(NetflixHeader.Node.headerName())) {
            this.withClientNode(value);
        } else if (this.vip == null && name.equalsIgnoreCase(NetflixHeader.Vip.headerName())) {
            this.withVip(value);
        } else {
            this.requestHeaders.add(new Header(name, value));
        }
        return this;
    }

    public IpcLogEntry addResponseHeader(String name, String value) {
        if (this.serverAsg == null && name.equalsIgnoreCase(NetflixHeader.ASG.headerName())) {
            this.withServerAsg(value);
        } else if (this.serverZone == null && name.equalsIgnoreCase(NetflixHeader.Zone.headerName())) {
            this.withServerZone(value);
        } else if (this.serverNode == null && name.equalsIgnoreCase(NetflixHeader.Node.headerName())) {
            this.withServerNode(value);
        } else if (this.endpoint == null && name.equalsIgnoreCase(NetflixHeader.Endpoint.headerName())) {
            this.withEndpoint(value);
        } else {
            this.responseHeaders.add(new Header(name, value));
        }
        return this;
    }

    public IpcLogEntry withRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public IpcLogEntry withRemotePort(int remotePort) {
        this.remotePort = remotePort;
        return this;
    }

    public IpcLogEntry addTag(Tag tag) {
        this.additionalTags.put(tag.key(), tag.value());
        return this;
    }

    public IpcLogEntry addTag(String k, String v) {
        this.additionalTags.put(k, v);
        return this;
    }

    private void putTag(Map<String, String> tags, Tag tag) {
        if (tag != null) {
            tags.put(tag.key(), tag.value());
        }
    }

    private void putTag(Map<String, String> tags, String k, String v) {
        if (IpcLogEntry.notNullOrEmpty(v)) {
            String value = this.logger.limiterForKey(k).apply(v);
            tags.put(k, value);
        }
    }

    private IpcResult getResult() {
        if (this.result == null) {
            this.result = this.status == null ? IpcResult.success : this.status.result();
        }
        return this.result;
    }

    private IpcStatus getStatus() {
        if (this.status == null) {
            this.status = this.result == IpcResult.success ? IpcStatus.success : IpcStatus.unexpected_error;
        }
        return this.status;
    }

    private IpcAttempt getAttempt() {
        if (this.attempt == null) {
            this.attempt = IpcAttempt.forAttemptNumber(1);
        }
        return this.attempt;
    }

    private IpcAttemptFinal getAttemptFinal() {
        if (this.attemptFinal == null) {
            this.attemptFinal = IpcAttemptFinal.is_true;
        }
        return this.attemptFinal;
    }

    private String getEndpoint() {
        return this.endpoint == null ? (this.path == null ? "unknown" : PathSanitizer.sanitize(this.path)) : this.endpoint;
    }

    private boolean isClient() {
        return this.marker != null && "ipc-client".equals(this.marker.getName());
    }

    private Id createCallId(String name) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.additionalTags.entrySet()) {
            this.putTag(tags, entry.getKey(), entry.getValue());
        }
        this.putTag(tags, IpcTagKey.owner.key(), this.owner);
        this.putTag(tags, this.getResult());
        this.putTag(tags, this.getStatus());
        if (this.isClient()) {
            this.putTag(tags, this.getAttempt());
            this.putTag(tags, this.getAttemptFinal());
            this.putTag(tags, IpcTagKey.serverApp.key(), this.serverApp);
            this.putTag(tags, IpcTagKey.serverCluster.key(), this.serverCluster);
            this.putTag(tags, IpcTagKey.serverAsg.key(), this.serverAsg);
        } else {
            this.putTag(tags, IpcTagKey.clientApp.key(), this.clientApp);
            this.putTag(tags, IpcTagKey.clientCluster.key(), this.clientCluster);
            this.putTag(tags, IpcTagKey.clientAsg.key(), this.clientAsg);
        }
        this.putTag(tags, IpcTagKey.endpoint.key(), this.getEndpoint());
        this.putTag(tags, IpcTagKey.vip.key(), this.vip);
        this.putTag(tags, IpcTagKey.protocol.key(), this.protocol);
        this.putTag(tags, IpcTagKey.statusDetail.key(), this.statusDetail);
        this.putTag(tags, IpcTagKey.httpStatus.key(), Integer.toString(this.httpStatus));
        this.putTag(tags, IpcTagKey.httpMethod.key(), this.httpMethod);
        return this.registry.createId(name, tags);
    }

    private Id getInflightId() {
        if (this.inflightId == null) {
            HashMap<String, String> tags = new HashMap<String, String>();
            this.putTag(tags, IpcTagKey.owner.key(), this.owner);
            this.putTag(tags, IpcTagKey.vip.key(), this.vip);
            String name = this.isClient() ? IpcMetric.clientInflight.metricName() : IpcMetric.serverInflight.metricName();
            this.inflightId = this.registry.createId(name, tags);
        }
        return this.inflightId;
    }

    private void recordClientMetrics() {
        Id clientCall = this.createCallId(IpcMetric.clientCall.metricName());
        PercentileTimer.builder(this.registry).withId(clientCall).build().record(this.getLatency(), TimeUnit.NANOSECONDS);
        if (this.responseContentLength >= 0L) {
            Id clientCallSizeInbound = this.registry.createId(IpcMetric.clientCallSizeInbound.metricName(), clientCall.tags());
            this.registry.distributionSummary(clientCallSizeInbound).record(this.responseContentLength);
        }
        if (this.requestContentLength >= 0L) {
            Id clientCallSizeOutbound = this.registry.createId(IpcMetric.clientCallSizeOutbound.metricName(), clientCall.tags());
            this.registry.distributionSummary(clientCallSizeOutbound).record(this.requestContentLength);
        }
    }

    private void recordServerMetrics() {
        Id serverCall = this.createCallId(IpcMetric.serverCall.metricName());
        PercentileTimer.builder(this.registry).withId(serverCall).build().record(this.getLatency(), TimeUnit.NANOSECONDS);
        if (this.requestContentLength >= 0L) {
            Id serverCallSizeInbound = this.registry.createId(IpcMetric.serverCallSizeInbound.metricName(), serverCall.tags());
            this.registry.distributionSummary(serverCallSizeInbound).record(this.requestContentLength);
        }
        if (this.responseContentLength >= 0L) {
            Id serverCallSizeOutbound = this.registry.createId(IpcMetric.serverCallSizeOutbound.metricName(), serverCall.tags());
            this.registry.distributionSummary(serverCallSizeOutbound).record(this.responseContentLength);
        }
    }

    public void log() {
        if (this.logger != null) {
            if (this.registry != null) {
                if (this.isClient()) {
                    this.recordClientMetrics();
                } else {
                    this.recordServerMetrics();
                }
            }
            if (this.inflightId != null) {
                this.logger.inflightRequests(this.inflightId).decrementAndGet();
            }
            this.logger.log(this);
        } else {
            this.reset();
        }
    }

    Level getLevel() {
        return this.level;
    }

    Marker getMarker() {
        return this.marker;
    }

    boolean isSuccessful() {
        return this.result == IpcResult.success;
    }

    private String extractRegionFromZone(String zone) {
        int n = zone.length();
        if (n < 4) {
            return null;
        }
        char c = zone.charAt(n - 2);
        if (Character.isDigit(c) && zone.charAt(n - 3) == '-') {
            return zone.substring(0, n - 1);
        }
        if (c == '-') {
            return zone.substring(0, n - 2);
        }
        return null;
    }

    private long getLatency() {
        if (this.startNanos >= 0L && this.latency < 0L) {
            this.latency = this.clock.monotonicTime() - this.startNanos;
        }
        return this.latency;
    }

    private String getExceptionClass() {
        return this.exception == null ? null : this.exception.getClass().getName();
    }

    private String getExceptionMessage() {
        return this.exception == null ? null : this.exception.getMessage();
    }

    private void putInMDC(String key, String value) {
        if (value != null && !value.isEmpty()) {
            MDC.put(key, value);
        }
    }

    private void putInMDC(Tag tag) {
        if (tag != null) {
            this.putInMDC(tag.key(), tag.value());
        }
    }

    void populateMDC() {
        this.putInMDC("marker", this.marker.getName());
        this.putInMDC("uri", this.uri);
        this.putInMDC("path", this.path);
        this.putInMDC(IpcTagKey.endpoint.key(), this.endpoint);
        this.putInMDC(IpcTagKey.owner.key(), this.owner);
        this.putInMDC(IpcTagKey.protocol.key(), this.protocol);
        this.putInMDC(IpcTagKey.vip.key(), this.vip);
        this.putInMDC("ipc.client.region", this.clientRegion);
        this.putInMDC("ipc.client.zone", this.clientZone);
        this.putInMDC("ipc.client.node", this.clientNode);
        this.putInMDC(IpcTagKey.clientApp.key(), this.clientApp);
        this.putInMDC(IpcTagKey.clientCluster.key(), this.clientCluster);
        this.putInMDC(IpcTagKey.clientAsg.key(), this.clientAsg);
        this.putInMDC("ipc.server.region", this.serverRegion);
        this.putInMDC("ipc.server.zone", this.serverZone);
        this.putInMDC("ipc.server.node", this.serverNode);
        this.putInMDC(IpcTagKey.serverApp.key(), this.serverApp);
        this.putInMDC(IpcTagKey.serverCluster.key(), this.serverCluster);
        this.putInMDC(IpcTagKey.serverAsg.key(), this.serverAsg);
        this.putInMDC("ipc.remote.address", this.remoteAddress);
        this.putInMDC("ipc.remote.port", Integer.toString(this.remotePort));
        this.putInMDC(this.attempt);
        this.putInMDC(this.attemptFinal);
        this.putInMDC(this.result);
        this.putInMDC(this.status);
        this.putInMDC(IpcTagKey.statusDetail.key(), this.statusDetail);
        this.putInMDC(IpcTagKey.httpMethod.key(), this.httpMethod);
        this.putInMDC(IpcTagKey.httpStatus.key(), Integer.toString(this.httpStatus));
    }

    public String toString() {
        return new JsonStringBuilder(this.builder).startObject().addField("owner", this.owner).addField("start", this.startTime).addField("latency", (double)this.getLatency() / 1.0E9).addField("protocol", this.protocol).addField("uri", this.uri).addField("path", this.path).addField("endpoint", this.getEndpoint()).addField("vip", this.vip).addField("clientRegion", this.clientRegion).addField("clientZone", this.clientZone).addField("clientApp", this.clientApp).addField("clientCluster", this.clientCluster).addField("clientAsg", this.clientAsg).addField("clientNode", this.clientNode).addField("serverRegion", this.serverRegion).addField("serverZone", this.serverZone).addField("serverApp", this.serverApp).addField("serverCluster", this.serverCluster).addField("serverAsg", this.serverAsg).addField("serverNode", this.serverNode).addField("remoteAddress", this.remoteAddress).addField("remotePort", this.remotePort).addField("attempt", this.attempt).addField("attemptFinal", this.attemptFinal).addField("result", this.result).addField("status", this.status).addField("statusDetail", this.statusDetail).addField("exceptionClass", this.getExceptionClass()).addField("exceptionMessage", this.getExceptionMessage()).addField("httpMethod", this.httpMethod).addField("httpStatus", this.httpStatus).addField("requestContentLength", this.requestContentLength).addField("responseContentLength", this.responseContentLength).addField("requestHeaders", this.requestHeaders).addField("responseHeaders", this.responseHeaders).addField("additionalTags", this.additionalTags).endObject().toString();
    }

    void reset() {
        this.logger = null;
        this.level = Level.DEBUG;
        this.marker = null;
        this.startTime = -1L;
        this.startNanos = -1L;
        this.latency = -1L;
        this.owner = null;
        this.result = null;
        this.protocol = null;
        this.status = null;
        this.statusDetail = null;
        this.exception = null;
        this.attempt = null;
        this.attemptFinal = null;
        this.vip = null;
        this.endpoint = null;
        this.clientRegion = null;
        this.clientZone = null;
        this.clientApp = null;
        this.clientCluster = null;
        this.clientAsg = null;
        this.clientNode = null;
        this.serverRegion = null;
        this.serverZone = null;
        this.serverApp = null;
        this.serverCluster = null;
        this.serverAsg = null;
        this.serverNode = null;
        this.httpMethod = null;
        this.httpStatus = -1;
        this.uri = null;
        this.path = null;
        this.requestContentLength = -1L;
        this.responseContentLength = -1L;
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.remoteAddress = null;
        this.remotePort = -1;
        this.additionalTags.clear();
        this.builder.delete(0, this.builder.length());
        this.inflightId = null;
    }

    void resetForRetry() {
        this.startTime = -1L;
        this.startNanos = -1L;
        this.latency = -1L;
        this.result = null;
        this.status = null;
        this.statusDetail = null;
        this.exception = null;
        this.attempt = null;
        this.attemptFinal = null;
        this.vip = null;
        this.serverRegion = null;
        this.serverZone = null;
        this.serverApp = null;
        this.serverCluster = null;
        this.serverAsg = null;
        this.serverNode = null;
        this.httpStatus = -1;
        this.requestContentLength = -1L;
        this.responseContentLength = -1L;
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.remoteAddress = null;
        this.remotePort = -1;
        this.builder.delete(0, this.builder.length());
        this.inflightId = null;
    }

    public <T> T convert(Function<IpcLogEntry, T> mapper) {
        return mapper.apply(this);
    }

    private static boolean notNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    private static class JsonStringBuilder {
        private final StringBuilder builder;
        private boolean firstEntry = true;

        JsonStringBuilder(StringBuilder builder) {
            this.builder = builder;
        }

        JsonStringBuilder startObject() {
            this.builder.append('{');
            return this;
        }

        JsonStringBuilder endObject() {
            this.builder.append('}');
            return this;
        }

        private void addSep() {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.builder.append(',');
            }
        }

        JsonStringBuilder addField(String k, String v) {
            if (IpcLogEntry.notNullOrEmpty(v)) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":\"");
                this.escapeAndAppend(this.builder, v);
                this.builder.append('\"');
            }
            return this;
        }

        JsonStringBuilder addField(String k, Tag tag) {
            if (tag != null) {
                this.addField(k, tag.value());
            }
            return this;
        }

        JsonStringBuilder addField(String k, int v) {
            if (v >= 0) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":").append(v);
            }
            return this;
        }

        JsonStringBuilder addField(String k, long v) {
            if (v >= 0L) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":").append(v);
            }
            return this;
        }

        JsonStringBuilder addField(String k, double v) {
            if (v >= 0.0) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":").append(v);
            }
            return this;
        }

        JsonStringBuilder addField(String k, List<Header> headers) {
            if (!headers.isEmpty()) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":[");
                boolean first = true;
                for (Header h : headers) {
                    if (first) {
                        first = false;
                    } else {
                        this.builder.append(',');
                    }
                    this.builder.append("{\"name\":\"");
                    this.escapeAndAppend(this.builder, h.name());
                    this.builder.append("\",\"value\":\"");
                    this.escapeAndAppend(this.builder, h.value());
                    this.builder.append("\"}");
                }
                this.builder.append(']');
            }
            return this;
        }

        JsonStringBuilder addField(String k, Map<String, String> tags) {
            if (!tags.isEmpty()) {
                this.addSep();
                this.builder.append('\"');
                this.escapeAndAppend(this.builder, k);
                this.builder.append("\":{");
                boolean first = true;
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.builder.append(',');
                    }
                    this.builder.append('\"');
                    this.escapeAndAppend(this.builder, entry.getKey());
                    this.builder.append("\":\"");
                    this.escapeAndAppend(this.builder, entry.getValue());
                    this.builder.append('\"');
                }
                this.builder.append('}');
            }
            return this;
        }

        private void escapeAndAppend(StringBuilder builder, String str) {
            int length = str.length();
            block9: for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '\"': {
                        builder.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        builder.append("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        builder.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        builder.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        builder.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        builder.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        builder.append("\\t");
                        continue block9;
                    }
                    default: {
                        if (Character.isISOControl(c)) continue block9;
                        builder.append(c);
                    }
                }
            }
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    private static class Header {
        private final String name;
        private final String value;

        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String name() {
            return this.name;
        }

        String value() {
            return this.value;
        }
    }
}

