/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc.http;

import java.net.URI;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Spectator;
import spectator-agent.spectator.ipc.IpcLogger;
import spectator-agent.spectator.ipc.http.HttpRequestBuilder;

public interface HttpClient {
    public static final IpcLogger DEFAULT_LOGGER = new IpcLogger(Spectator.globalRegistry(), LoggerFactory.getLogger(HttpClient.class));
    public static final HttpClient DEFAULT_CLIENT = HttpClient.create(DEFAULT_LOGGER);

    public static HttpClient create(Registry registry) {
        return HttpClient.create(new IpcLogger(registry, LoggerFactory.getLogger(HttpClient.class)));
    }

    public static HttpClient create(IpcLogger logger) {
        return uri -> new HttpRequestBuilder(logger, uri);
    }

    public HttpRequestBuilder newRequest(URI var1);

    default public HttpRequestBuilder get(URI uri) {
        return this.newRequest(uri).withMethod("GET");
    }

    default public HttpRequestBuilder post(URI uri) {
        return this.newRequest(uri).withMethod("POST");
    }

    default public HttpRequestBuilder put(URI uri) {
        return this.newRequest(uri).withMethod("PUT");
    }

    default public HttpRequestBuilder delete(URI uri) {
        return this.newRequest(uri).withMethod("DELETE");
    }
}

